/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class QSStringUtil {
    public static String objectToJson(String key, Object o) {
        StringBuffer buffer = new StringBuffer("{ \"" + key + "\":");
        buffer.append(QSStringUtil.objectJSONKeyValue(key, o));
        buffer.append("}");
        return buffer.toString();
    }

    private static String objectJSONKeyValue(String key, Object o) {
        StringBuffer buffer = new StringBuffer(" \"" + key + "\":");
        buffer.append(QSStringUtil.objectJSONValue(o));
        return buffer.toString();
    }

    private static String objectJSONValue(Object o) {
        StringBuffer buffer = new StringBuffer();
        if (o instanceof List) {
            List lst = (List)o;
            buffer.append("[");
            int i = 0;
            while (i < lst.size()) {
                buffer.append(QSStringUtil.objectJSONValue(lst.get(i)));
                if (i + 1 < lst.size()) {
                    buffer.append(",");
                }
                ++i;
            }
            buffer.append("]");
        } else if (o instanceof Integer || o instanceof Double || o instanceof Boolean || o instanceof Long || o instanceof Float) {
            buffer.append(o);
        } else if (o instanceof String) {
            buffer.append("\"").append(o).append("\"");
        } else {
            buffer.append(QSStringUtil.getObjectToJson(o));
        }
        return buffer.toString();
    }

    public static String getObjectToJson(Object o) {
        JSONObject json = null;
        if (o instanceof Map) {
            json = new JSONObject();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                String key = (String)entry.getKey();
                Object bodyObj = ((Map)o).get(key);
                json.put(key, bodyObj);
            }
        } else {
            json = new JSONObject(o);
        }
        return json.toString();
    }

    public static String percentEncode(String value, String encoding) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, encoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static String getUserAgent() {
        String osName = System.getProperty("os.name");
        String langVersion = System.getProperty("java.version");
        String userAgent = String.valueOf(QSConstant.SDK_NAME) + "/" + QSConstant.SDK_VERSION + " ( java v" + langVersion + ";" + osName + ")";
        return userAgent;
    }

    public static String getParameterRequired(String paraName, String value) {
        return String.format("%s is required in %s ", paraName, value);
    }

    public static String getParameterValueNotAllowedError(String paraName, String value, String[] values) {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            buf.append(o.toString()).append(",");
            ++n2;
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return String.format("%s value %s is not allowed, should be one of %s ", paraName, value, buf.toString());
    }

    public static String asciiCharactersEncoding(String str) throws QSException {
        if (QSStringUtil.isEmpty(str)) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(str, "UTF-8");
            encoded = encoded.replace("%2F", "/");
            encoded = encoded.replace("%3D", "=");
            encoded = encoded.replace("+", "%20");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("UnsupportedEncodingException:", e);
        }
    }
}

