/*
 * Decompiled with CFR 0.152.
 */
package msgcenter.api.sdk.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cloud.api.sdk.HttpResponseBody;
import com.cloud.api.sdk.RequestEnvironment;
import com.cloud.api.sdk.RequestHeader;
import com.cloud.api.sdk.RequestMethod;
import com.cloud.api.sdk.RequestParameter;
import com.cloud.api.sdk.client.RequestClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import msgcenter.api.sdk.util.bo.CrcMcSendtask;
import msgcenter.api.sdk.util.bo.Result;
import msgcenter.api.sdk.util.bo.ResultGenerator;
import msgcenter.api.sdk.util.bo.SmsSendDTO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneMsgSender {
    private String appId;
    private String appkey;
    private String appSecrect;
    private String url = "https://api-msct.crcloud.com/api";
    private String submiter = "13420934049";
    private String submiterName = "13420934049";
    private String tenantId = "316533120295956480";
    private static Logger logger = LoggerFactory.getLogger(PhoneMsgSender.class);

    public PhoneMsgSender(String appId, String appkey, String appSecrect, String submiterName, String tenantId) {
        this.appId = appId;
        this.appkey = appkey;
        this.appSecrect = appSecrect;
        this.submiterName = submiterName;
        this.submiter = submiterName;
        this.tenantId = tenantId;
    }

    public Result<CrcMcSendtask> phoneMsgSingleSend(String signCode, String templateCode, String phoneNumer, Map<String, String> msg_tplparams2) {
        SmsSendDTO inBody = new SmsSendDTO();
        inBody.setAppId(this.appId);
        inBody.setSubmiter(this.submiter);
        inBody.setSubmiterName(this.submiterName);
        inBody.setSignCode(signCode);
        inBody.setTemplateCode(templateCode);
        inBody.setMsg_tplparams2(msg_tplparams2);
        inBody.setPhoneNumber(phoneNumer);
        inBody.setSubmiterName(this.submiterName);
        inBody.setTenantId(this.tenantId);
        logger.debug("input params to json is :" + JSON.toJSONString((Object)inBody));
        return this.singleSendMsgWithParams(inBody);
    }

    private Result singleSendMsgWithParams(SmsSendDTO body) {
        try {
            String resultStr = this.validParams(body, "single");
            if (StringUtils.isNotEmpty((CharSequence)resultStr)) {
                return ResultGenerator.genFailResult(resultStr);
            }
            if (StringUtils.isEmpty((CharSequence)body.getNationCode())) {
                body.setNationCode("86");
            }
            String tenantId = body.getTenantId();
            String bodyData = JSON.toJSONString((Object)body);
            RequestParameter requestParameter = null;
            HttpResponseBody rs = this.sendUtil("crc.jvku.smscommsend", bodyData, requestParameter);
            Map resultMap = rs.getResponseMap();
            CrcMcSendtask taskinfo = new CrcMcSendtask();
            if (resultMap.get("stateCode").equals(200)) {
                JSONObject jsonObject = JSON.parseObject((String)resultMap.get("responseBody").toString());
                if (jsonObject != null) {
                    if (jsonObject.get((Object)"code").equals(200) && jsonObject.get((Object)"message").equals("SUCCESS")) {
                        JSONObject data = JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"data")));
                        if (data != null) {
                            String appId = data.getString("appId");
                            String taskGuid = data.getString("taskGuid");
                            String parentId = data.getString("parentId");
                            String chanelType = data.getString("chanelType");
                            String templateCode = data.getString("templateId");
                            String taskStatus = data.getString("taskStatus");
                            String submiter = data.getString("createBy");
                            String submitname = data.getString("createName");
                            String rstenantId = data.getString("tenantId");
                            taskinfo.setAppId(appId);
                            taskinfo.setTaskGuid(taskGuid);
                            taskinfo.setParentId(parentId);
                            taskinfo.setChanelType(chanelType);
                            taskinfo.setTemplateId(templateCode);
                            taskinfo.setTaskStatus(Integer.parseInt(taskStatus));
                            taskinfo.setSubmiter(submiter);
                            taskinfo.setSubmiterName(submitname);
                            taskinfo.setTenantId(rstenantId);
                        } else {
                            ResultGenerator.genFailResult("\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a.");
                        }
                    } else {
                        ResultGenerator.genFailResult("\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u7801\u4e3a\u5931\u8d25.");
                    }
                } else {
                    ResultGenerator.genFailResult("\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u5931\u8d25.");
                }
            } else {
                ResultGenerator.genFailResult("\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u4fe1\u606fstateCode\u5f02\u5e38.");
            }
            return ResultGenerator.genSuccessResult(taskinfo);
        }
        catch (Exception ex) {
            logger.error("invoke send inf failed", (Throwable)ex);
            return ResultGenerator.genFailResult("\u77ed\u4fe1\u5355\u53d1\u5f02\u5e38\uff0c" + ex.getMessage());
        }
    }

    private String validParams(SmsSendDTO body, String upFlag) {
        if (StringUtils.isBlank((CharSequence)body.getSignCode())) {
            return "signCode param required. ";
        }
        if (StringUtils.isBlank((CharSequence)body.getTemplateCode())) {
            return "templateCode param required. ";
        }
        if ("single".equals(upFlag)) {
            if (StringUtils.isEmpty((CharSequence)body.getPhoneNumber())) {
                return "phoneNumber param required.";
            }
        } else if ("multi".equals(upFlag) && (body.getPhoneNumbers() == null || body.getPhoneNumbers().isEmpty())) {
            return "phoneNumbers param required.";
        }
        return null;
    }

    private HttpResponseBody sendUtil(String input_apiId, String bodyData, RequestParameter requestParameter) throws ClientProtocolException, IOException {
        RequestHeader header = new RequestHeader(this.appId, this.appkey, input_apiId, RequestEnvironment.PRD);
        RequestParameter apiParameter = new RequestParameter("/", bodyData);
        HttpResponseBody body = RequestClient.call((String)this.url, (RequestMethod)RequestMethod.POST, (RequestHeader)header, (RequestParameter)apiParameter, (String)this.appSecrect, (String)"s-crc-app-id,s-crc-api-id,s-crc-stage");
        System.out.println(body.getBody());
        System.out.println(body.getRequestMap());
        System.out.println(body.getResponseMap());
        return body;
    }

    public static void main(String[] args) {
        PhoneMsgSender s = new PhoneMsgSender("958", "4ffcc4db10d14d9788ba0e85185ffe2a", "53fc09e09cae4345895088accf53ba5f", "13420934049", "316533120295956480");
        String phoneNumber = "13420934049";
        HashMap<String, String> msg_tplparams21 = new HashMap<String, String>();
        msg_tplparams21.put("key", "121311");
        msg_tplparams21.put("time", "5");
        Result<CrcMcSendtask> aa = s.phoneMsgSingleSend("MT_S_0_RunLianKeJi", "MT_T_1_PassWord_324126488144289792", phoneNumber, msg_tplparams21);
        System.out.println(aa.getData().getTaskGuid());
        System.out.println(aa.getData().getTaskStatus());
    }
}

