/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlog.template.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.crmlog.template.repositories.LogTemplateRepositories;
import com.biz.crm.crmlog.template.service.LogTemplateService;
import com.biz.crm.crmlog.template.util.LogTemplateUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"logTemplateServiceImpl"})
@Service(value="logTemplateService")
public class LogTemplateServiceImpl
implements LogTemplateService {
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private LogTemplateRepositories logTemplateRepositories;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void add(LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        LogTemplateEntity logTemplateEntity = LogTemplateUtil.voToEntityForAdd(vo);
        this.logTemplateRepositories.save(logTemplateEntity);
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(vo.getMenuCode()), (Object)JSON.toJSONString((Object)logTemplateEntity));
    }

    @Override
    public PageResult<LogTemplateVo> listWithPage(LogTemplateVo vo) {
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, LogTemplateEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((String)vo.getMenuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"menuCode.keyword", (String)vo.getMenuCode()));
        }
        if (!StringUtils.isEmpty((String)vo.getTypeClassPath())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"typeClassPath.keyword", (String)vo.getTypeClassPath()));
        }
        if (null != vo.getEnableFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"enableFlag", (Object)vo.getEnableFlag()));
        }
        if (!StringUtils.isEmpty((String)vo.getBusinessName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"businessName", (Object)vo.getBusinessName()));
        }
        String[] fileds = new String[]{"id", "menuCode", "businessName", "typeClassPath", "enableFlag"};
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"es_log_template_index"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(vo.getPageNum() - 1), (int)vo.getPageSize())).withFields(fileds).build();
        AggregatedPage scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, LogTemplateEntity.class);
        List list = scroll.getContent();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageResult;
        }
        ArrayList<LogTemplateVo> listVo = new ArrayList<LogTemplateVo>(list.size());
        for (LogTemplateEntity entity : list) {
            LogTemplateVo logTemplateVo = new LogTemplateVo();
            BeanUtils.copyProperties((Object)entity, (Object)logTemplateVo);
            listVo.add(logTemplateVo);
        }
        pageResult.setData(listVo);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public LogTemplateVo findById(String id) {
        LogTemplateVo reVo = new LogTemplateVo();
        Optional optional = this.logTemplateRepositories.findById(id);
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)optional.get();
        BeanUtils.copyProperties((Object)logTemplateEntity, (Object)reVo);
        ArrayList<LogFieldVo> fieldList = new ArrayList<LogFieldVo>();
        reVo.setFieldList(fieldList);
        String fieldListStr = logTemplateEntity.getFieldListStr();
        if (StringUtils.isEmpty((String)fieldListStr)) {
            return reVo;
        }
        List fileds = JSONArray.parseArray((String)fieldListStr, LogFieldEntity.class);
        for (LogFieldEntity logFieldEntity : fileds) {
            LogFieldVo logFieldVo = new LogFieldVo();
            BeanUtils.copyProperties((Object)logFieldEntity, (Object)logFieldVo);
            fieldList.add(logFieldVo);
            if (logFieldVo.getHostType().intValue() == LogEunm.HostTypeEunm.BASIC.getCode().intValue() || StringUtils.isEmpty((String)logFieldEntity.getChildrenListStr())) continue;
            logFieldVo.setChildrenList(JSONArray.parseArray((String)logFieldEntity.getChildrenListStr(), LogFieldVo.class));
        }
        return reVo;
    }

    @Override
    public void update(LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u6a21\u677f!");
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        Optional optional = this.logTemplateRepositories.findById(vo.getId());
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u8d27\u5df2\u7ecf\u88ab\u5220\u9664\uff01");
        }
        LogTemplateEntity logTemplateEntity = LogTemplateUtil.voToEntityForUpdate(vo, (LogTemplateEntity)optional.get());
        this.logTemplateRepositories.deleteById(vo.getId());
        this.logTemplateRepositories.save(logTemplateEntity);
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(vo.getMenuCode()), (Object)JSON.toJSONString((Object)logTemplateEntity));
    }

    @Override
    public void updateEnable(String id, YesNoEnum.YesNoCodeNumberEnum yesNoCodeNumberEnum) {
        Optional optional = this.logTemplateRepositories.findById(id);
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)optional.get();
        logTemplateEntity.setEnableFlag(yesNoCodeNumberEnum.getCode());
        this.logTemplateRepositories.deleteById(logTemplateEntity.getId());
        this.logTemplateRepositories.save(logTemplateEntity);
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(logTemplateEntity.getMenuCode()), (Object)JSON.toJSONString((Object)logTemplateEntity));
    }

    @Override
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Iterable entities = this.logTemplateRepositories.findAllById(ids);
        this.logTemplateRepositories.deleteByIdIn(ids);
        if (null == entities || !entities.iterator().hasNext()) {
            return;
        }
        ArrayList<String> codes = new ArrayList<String>();
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            codes.add(LogTemplateUtil.packageRedisKey(((LogTemplateEntity)iterator.next()).getMenuCode()));
        }
        this.redisTemplate.delete(codes);
    }

    @Override
    public List<LogFieldVo> findFieldsByType(String type) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u7c7b\u4e0d\u5b58\u5728", (Throwable)e);
        }
        return LogTemplateUtil.packageFiledVo(LogTemplateUtil.getFields(clazz));
    }

    @Override
    public LogTemplateEntity findTemplateByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        String str = (String)this.redisTemplate.opsForValue().get((Object)LogTemplateUtil.packageRedisKey(code));
        if (StringUtils.isEmpty((String)str)) {
            LogTemplateEntity logTemplateEntity = this.findTemplateByCodeFromEs(code);
            String value = "";
            value = null == logTemplateEntity ? "crmLog" : JSON.toJSONString((Object)logTemplateEntity);
            this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(code), (Object)value);
            return logTemplateEntity;
        }
        if (str.equals("crmLog")) {
            return null;
        }
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)JSON.parseObject((String)str, LogTemplateEntity.class);
        HashMap<String, LogFieldEntity> fieldMap = new HashMap<String, LogFieldEntity>();
        logTemplateEntity.setFieldMap(fieldMap);
        return LogTemplateUtil.transformEntity(logTemplateEntity, fieldMap);
    }

    @Override
    public LogTemplateEntity findTemplateByCodeFromEs(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        LogTemplateEntity logTemplateEntity = this.logTemplateRepositories.findByMenuCode(code);
        if (null == logTemplateEntity) {
            return null;
        }
        HashMap<String, LogFieldEntity> fieldMap = new HashMap<String, LogFieldEntity>();
        logTemplateEntity.setFieldMap(fieldMap);
        return LogTemplateUtil.transformEntity(logTemplateEntity, fieldMap);
    }
}

