/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlog.template.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class LogTemplateUtil {
    public static final String redisPrefix = "crmLog";

    public static String packageRedisKey(String code) {
        return redisPrefix + code;
    }

    public static LogTemplateEntity voToEntityForAdd(LogTemplateVo vo) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        entity.setId(UUIDGenerator.generate());
        entity.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        entity.setFieldListStr(JSON.toJSONString(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true)));
        return entity;
    }

    public static LogTemplateEntity voToEntityForUpdate(LogTemplateVo vo, LogTemplateEntity logTemplateEntity) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        entity.setId(logTemplateEntity.getId());
        entity.setFieldListStr(JSON.toJSONString(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true)));
        return entity;
    }

    public static List<LogFieldEntity> voToEntityForField(List<LogFieldVo> filedVods, boolean subFlag) {
        if (com.alibaba.excel.util.CollectionUtils.isEmpty(filedVods)) {
            return new ArrayList<LogFieldEntity>();
        }
        ArrayList<LogFieldEntity> reList = new ArrayList<LogFieldEntity>();
        for (LogFieldVo fieldVo : filedVods) {
            LogFieldEntity fieldEntity = new LogFieldEntity();
            BeanUtils.copyProperties((Object)fieldVo, (Object)fieldEntity);
            if (subFlag) {
                List<LogFieldEntity> subList = LogTemplateUtil.voToEntityForField(fieldVo.getChildrenList(), false);
                fieldEntity.setChildrenListStr(JSON.toJSONString(subList));
            }
            reList.add(fieldEntity);
        }
        return reList;
    }

    public static Integer judgeClass(Class claszz) {
        if (claszz == Integer.class || claszz == Double.class || claszz == Long.class || claszz == Float.class || claszz == Character.class || claszz == Byte.class || claszz == String.class || claszz == BigDecimal.class) {
            return LogEunm.HostTypeEunm.BASIC.getCode();
        }
        if (Collection.class.isAssignableFrom(claszz)) {
            return LogEunm.HostTypeEunm.ONE2MANY.getCode();
        }
        return LogEunm.HostTypeEunm.ONE2ONE.getCode();
    }

    public static List<LogFieldVo> packageFiledVo(List<Field> fields) {
        if (com.alibaba.excel.util.CollectionUtils.isEmpty(fields)) {
            return new ArrayList<LogFieldVo>();
        }
        ArrayList<LogFieldVo> reList = new ArrayList<LogFieldVo>(fields.size());
        for (Field field : fields) {
            ApiModelProperty api = field.getAnnotation(ApiModelProperty.class);
            LogFieldVo vo = new LogFieldVo();
            vo.setFieldName(field.getName());
            vo.setDesc("");
            if (api != null) {
                vo.setDesc(api.value());
            }
            vo.setCompareFalg(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if (field.getType().isPrimitive()) {
                vo.setHostType(LogEunm.HostTypeEunm.BASIC.getCode());
            } else {
                vo.setHostType(LogTemplateUtil.judgeClass(field.getType()));
            }
            if (vo.getHostType().intValue() == LogEunm.HostTypeEunm.ONE2MANY.getCode().intValue()) {
                Type genericType = field.getGenericType();
                ParameterizedType type = (ParameterizedType)genericType;
                Class clazz = (Class)type.getActualTypeArguments()[0];
                vo.setType(clazz.getName());
            } else {
                vo.setType(field.getType().getName());
            }
            reList.add(vo);
        }
        return reList;
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList fields = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static LogTemplateEntity transformEntity(LogTemplateEntity logTemplateEntity, Map<String, LogFieldEntity> fieldMap) {
        if (StringUtils.isEmpty((String)logTemplateEntity.getFieldListStr())) {
            return null;
        }
        List fieldList = JSONArray.parseArray((String)logTemplateEntity.getFieldListStr(), LogFieldEntity.class);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return null;
        }
        for (LogFieldEntity logFieldEntity : fieldList) {
            fieldMap.put(logFieldEntity.getFieldName(), logFieldEntity);
            HashMap<String, LogFieldEntity> childrenMap = new HashMap<String, LogFieldEntity>();
            logFieldEntity.setChildren(childrenMap);
            if (StringUtils.isEmpty((String)logFieldEntity.getChildrenListStr())) continue;
            List childrenList = JSONArray.parseArray((String)logFieldEntity.getChildrenListStr(), LogFieldEntity.class);
            if (CollectionUtils.isEmpty((Collection)fieldList)) continue;
            for (LogFieldEntity chiledFiled : childrenList) {
                childrenMap.put(chiledFiled.getFieldName(), chiledFiled);
            }
        }
        return logTemplateEntity;
    }
}

