/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.client.GtHttpClient;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.util.Map;

public class HttpManager {
    private GtHttpClient client;

    public HttpManager() {
        this.init(GTConfig.getHttpConnectionTimeOut(), GTConfig.getHttpSoTimeOut(), GTConfig.getHttpTryCount());
    }

    private void init(int connectionTimeOut, int soTimeOut, int maxHttpTryTime) {
        this.client = new GtHttpClient(connectionTimeOut, soTimeOut, maxHttpTryTime);
    }

    public Map<String, Object> httpPostJSON(String url, Map<String, Object> data, boolean gzip) {
        Map<String, Object> response = null;
        try {
            response = this.client.executePostJson(url, data, gzip, gzip);
            return response;
        }
        catch (Exception e) {
            throw new RequestException((String)data.get("requestId"), "httpPost:[" + url + "] [" + data + " ] [ " + response + "]:", e);
        }
    }

    static {
        String proxyHost = GTConfig.getHttpProxyIp();
        int proxyPort = GTConfig.getHttpProxyPort();
        if (proxyHost != null && !"".equals(proxyHost.trim())) {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", String.valueOf(proxyPort));
        }
    }
}

