/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.routers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.StateRouter;
import io.seata.saga.engine.pcext.utils.CompensationHolder;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.Instruction;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.CompensateSubStateMachineState;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.SubStateMachine;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TaskStateRouter
implements StateRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStateRouter.class);

    @Override
    public Instruction route(ProcessContext context, State state) throws EngineExecutionException {
        StateInstruction stateInstruction = context.getInstruction(StateInstruction.class);
        if (stateInstruction.isEnd()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("StateInstruction is ended, Stop the StateMachine executing. StateMachine[{}] Current State[{}]", (Object)stateInstruction.getStateMachineName(), (Object)state.getName());
            }
            return null;
        }
        State compensationTriggerState = (State)context.getVariable("_is_compensating_");
        if (compensationTriggerState != null) {
            return this.compensateRoute(context, compensationTriggerState);
        }
        String next = (String)context.getVariable("_current_exception_route_");
        if (StringUtils.hasLength((String)next)) {
            context.removeVariable("_current_exception_route_");
        } else {
            next = state.getNext();
        }
        if (!StringUtils.hasLength((String)next) && context.hasVariable("_current_choice_")) {
            next = (String)context.getVariable("_current_choice_");
            context.removeVariable("_current_choice_");
        }
        if (!StringUtils.hasLength((String)next)) {
            return null;
        }
        StateMachine stateMachine = state.getStateMachine();
        State nextState = stateMachine.getState(next);
        if (nextState == null) {
            throw new EngineExecutionException("Next state[" + next + "] is not exits", FrameworkErrorCode.ObjectNotExists);
        }
        stateInstruction.setStateName(next);
        return stateInstruction;
    }

    private Instruction compensateRoute(ProcessContext context, State compensationTriggerState) {
        Stack<StateInstance> stateStackToBeCompensated;
        if (Boolean.TRUE.equals(context.getVariable("_first_compensation_state_started"))) {
            Exception exception = (Exception)context.getVariable("currentException");
            if (exception != null) {
                EngineUtils.endStateMachine(context);
                return null;
            }
            StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
            if (stateInstance != null && !ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                EngineUtils.endStateMachine(context);
                return null;
            }
        }
        if (!(stateStackToBeCompensated = CompensationHolder.getCurrent(context, true).getStateStackNeedCompensation()).isEmpty()) {
            StateInstance stateToBeCompensated = stateStackToBeCompensated.pop();
            StateMachine stateMachine = (StateMachine)context.getVariable("_current_statemachine_");
            State state = stateMachine.getState(stateToBeCompensated.getName());
            if (state != null && state instanceof AbstractTaskState) {
                AbstractTaskState taskState = (AbstractTaskState)state;
                StateInstruction instruction = context.getInstruction(StateInstruction.class);
                State compensateState = null;
                String compensateStateName = taskState.getCompensateState();
                if (StringUtils.hasLength((String)compensateStateName)) {
                    compensateState = stateMachine.getState(compensateStateName);
                }
                if (compensateState == null && taskState instanceof SubStateMachine) {
                    compensateState = ((SubStateMachine)((Object)taskState)).getCompensateStateObject();
                    instruction.setTemporaryState(compensateState);
                }
                if (compensateState == null) {
                    EngineUtils.endStateMachine(context);
                    return null;
                }
                instruction.setStateName(compensateState.getName());
                CompensationHolder.getCurrent(context, true).addToBeCompensatedState(compensateState.getName(), stateToBeCompensated);
                ((HierarchicalProcessContext)context).setVariableLocally("_first_compensation_state_started", true);
                if (compensateState instanceof CompensateSubStateMachineState) {
                    ((HierarchicalProcessContext)context).setVariableLocally(compensateState.getName() + "_sub_machine_parent_id_", EngineUtils.generateParentId(stateToBeCompensated));
                }
                return instruction;
            }
        }
        context.removeVariable("_is_compensating_");
        String compensationTriggerStateNext = compensationTriggerState.getNext();
        if (StringUtils.isEmpty((Object)compensationTriggerStateNext)) {
            EngineUtils.endStateMachine(context);
            return null;
        }
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        instruction.setStateName(compensationTriggerStateNext);
        return instruction;
    }
}

