/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.expression.Expression;
import io.seata.saga.engine.expression.ExpressionFactory;
import io.seata.saga.engine.expression.ExpressionFactoryManager;
import io.seata.saga.engine.expression.seq.SequenceExpression;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.StateInstanceImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ParameterUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> createInputParams(ExpressionFactoryManager expressionFactoryManager, StateInstanceImpl stateInstance, AbstractTaskState serviceTaskState, Object variablesFrom) {
        List<Object> inputAssignments = serviceTaskState.getInput();
        if (CollectionUtils.isEmpty(inputAssignments)) {
            return new ArrayList<Object>(0);
        }
        List<Object> inputExpressions = serviceTaskState.getInputExpressions();
        if (inputExpressions == null) {
            AbstractTaskState abstractTaskState = serviceTaskState;
            synchronized (abstractTaskState) {
                inputExpressions = serviceTaskState.getInputExpressions();
                if (inputExpressions == null) {
                    inputExpressions = new ArrayList<Object>(inputAssignments.size());
                    for (Object inputAssignment : inputAssignments) {
                        inputExpressions.add(ParameterUtils.createValueExpression(expressionFactoryManager, inputAssignment));
                    }
                }
                serviceTaskState.setInputExpressions(inputExpressions);
            }
        }
        ArrayList<Object> inputValues = new ArrayList<Object>(inputExpressions.size());
        for (Object valueExpression : inputExpressions) {
            Object value = ParameterUtils.getValue(valueExpression, variablesFrom, stateInstance);
            inputValues.add(value);
        }
        return inputValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> createOutputParams(ExpressionFactoryManager expressionFactoryManager, AbstractTaskState serviceTaskState, Object variablesFrom) {
        Map<String, Object> outputAssignments = serviceTaskState.getOutput();
        if (CollectionUtils.isEmpty(outputAssignments)) {
            return new LinkedHashMap<String, Object>(0);
        }
        Map<String, Object> outputExpressions = serviceTaskState.getOutputExpressions();
        if (outputExpressions == null) {
            AbstractTaskState abstractTaskState = serviceTaskState;
            synchronized (abstractTaskState) {
                outputExpressions = serviceTaskState.getOutputExpressions();
                if (outputExpressions == null) {
                    outputExpressions = new LinkedHashMap<String, Object>(outputAssignments.size());
                    for (Map.Entry entry : outputAssignments.entrySet()) {
                        outputExpressions.put((String)entry.getKey(), ParameterUtils.createValueExpression(expressionFactoryManager, entry.getValue()));
                    }
                }
                serviceTaskState.setOutputExpressions(outputExpressions);
            }
        }
        LinkedHashMap<String, Object> outputValues = new LinkedHashMap<String, Object>(outputExpressions.size());
        for (String string : outputExpressions.keySet()) {
            outputValues.put(string, ParameterUtils.getValue(outputExpressions.get(string), variablesFrom, null));
        }
        return outputValues;
    }

    public static Object getValue(Object valueExpression, Object variablesFrom, StateInstance stateInstance) {
        if (valueExpression instanceof Expression) {
            Object value2 = ((Expression)valueExpression).getValue(variablesFrom);
            if (value2 != null && stateInstance != null && StringUtils.isEmpty((Object)stateInstance.getBusinessKey()) && valueExpression instanceof SequenceExpression) {
                stateInstance.setBusinessKey(String.valueOf(value2));
            }
            return value2;
        }
        if (valueExpression instanceof Map) {
            Map mapValueExpression = (Map)valueExpression;
            LinkedHashMap mapValue = new LinkedHashMap();
            mapValueExpression.forEach((key, value) -> {
                if ((value = ParameterUtils.getValue(value, variablesFrom, stateInstance)) != null) {
                    mapValue.put(key, value);
                }
            });
            return mapValue;
        }
        if (valueExpression instanceof List) {
            List listValueExpression = (List)valueExpression;
            ArrayList<Object> listValue = new ArrayList<Object>(listValueExpression.size());
            for (Object aValueExpression : listValueExpression) {
                listValue.add(ParameterUtils.getValue(aValueExpression, variablesFrom, stateInstance));
            }
            return listValue;
        }
        return valueExpression;
    }

    public static Object createValueExpression(ExpressionFactoryManager expressionFactoryManager, Object paramAssignment) {
        Object valueExpression;
        if (paramAssignment instanceof Expression) {
            valueExpression = paramAssignment;
        } else if (paramAssignment instanceof Map) {
            Map paramMapAssignment = paramAssignment;
            LinkedHashMap paramMap = new LinkedHashMap(paramMapAssignment.size());
            paramMapAssignment.forEach((paramName, valueAssignment) -> paramMap.put(paramName, ParameterUtils.createValueExpression(expressionFactoryManager, valueAssignment)));
            valueExpression = paramMap;
        } else if (paramAssignment instanceof List) {
            List paramListAssignment = (List)((Object)paramAssignment);
            ArrayList<Object> paramList = new ArrayList<Object>(paramListAssignment.size());
            for (Object aParamAssignment : paramListAssignment) {
                paramList.add(ParameterUtils.createValueExpression(expressionFactoryManager, aParamAssignment));
            }
            valueExpression = paramList;
        } else if (paramAssignment instanceof String && ((String)((Object)paramAssignment)).startsWith("$")) {
            ExpressionFactory expressionFactory;
            String expressionStr = (String)((Object)paramAssignment);
            int expTypeStart = expressionStr.indexOf("$");
            int expTypeEnd = expressionStr.indexOf(".", expTypeStart);
            String expressionType = null;
            if (expTypeStart >= 0 && expTypeEnd > expTypeStart) {
                expressionType = expressionStr.substring(expTypeStart + 1, expTypeEnd);
            }
            int expEnd = expressionStr.length();
            String expressionContent = null;
            if (expTypeEnd > 0 && expEnd > expTypeEnd) {
                expressionContent = expressionStr.substring(expTypeEnd + 1, expEnd);
            }
            if ((expressionFactory = expressionFactoryManager.getExpressionFactory(expressionType)) == null) {
                throw new IllegalArgumentException("Cannot get ExpressionFactory by Type[" + expressionType + "]");
            }
            valueExpression = expressionFactory.createExpression(expressionContent);
        } else {
            valueExpression = paramAssignment;
        }
        return valueExpression;
    }
}

