/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.parser.impl.BaseStatePaser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaskStateParser
extends BaseStatePaser {
    protected void parseTaskAttributes(AbstractTaskState state, Object node) {
        Map statusMap;
        Map outputMap;
        List inputList;
        List catchList;
        List retryList;
        this.parseBaseAttributes(state, node);
        Map nodeMap = (Map)node;
        state.setCompensateState((String)nodeMap.get("CompensateState"));
        state.setForCompensation(Boolean.TRUE.equals(nodeMap.get("IsForCompensation")));
        state.setForUpdate(Boolean.TRUE.equals(nodeMap.get("IsForUpdate")));
        Object isPersist = nodeMap.get("IsPersist");
        if (Boolean.FALSE.equals(isPersist)) {
            state.setPersist(false);
        }
        if ((retryList = (List)nodeMap.get("Retry")) != null) {
            state.setRetry(this.parseRetry(retryList));
        }
        if ((catchList = (List)nodeMap.get("Catch")) != null) {
            state.setCatches(this.parseCatch(catchList));
        }
        if ((inputList = (List)nodeMap.get("Input")) != null) {
            state.setInput(inputList);
        }
        if ((outputMap = (Map)nodeMap.get("Output")) != null) {
            state.setOutput(outputMap);
        }
        if ((statusMap = (Map)nodeMap.get("Status")) != null) {
            state.setStatus(statusMap);
        }
    }

    protected List<TaskState.Retry> parseRetry(List<Object> retryList) {
        if (retryList != null) {
            ArrayList<TaskState.Retry> retries = new ArrayList<TaskState.Retry>(retryList.size());
            for (Object retryObj : retryList) {
                Map retryMap = (Map)retryObj;
                AbstractTaskState.RetryImpl retry = new AbstractTaskState.RetryImpl();
                retry.setExceptions((List)retryMap.get("Exceptions"));
                Object intervalSeconds = retryMap.get("IntervalSeconds");
                if (intervalSeconds != null && intervalSeconds instanceof Number) {
                    retry.setIntervalSeconds(((Number)intervalSeconds).doubleValue());
                }
                retry.setMaxAttempts((Integer)retryMap.get("MaxAttempts"));
                Object backoffRate = retryMap.get("BackoffRate");
                if (backoffRate != null && backoffRate instanceof Number) {
                    retry.setBackoffRate(((Number)backoffRate).doubleValue());
                }
                retries.add(retry);
            }
            return retries;
        }
        return new ArrayList<TaskState.Retry>(0);
    }

    protected List<TaskState.ExceptionMatch> parseCatch(List<Object> catchList) {
        ArrayList<TaskState.ExceptionMatch> exceptionMatchList = new ArrayList<TaskState.ExceptionMatch>(catchList.size());
        for (Object exceptionMatchObj : catchList) {
            Map exceptionMatchMap = (Map)exceptionMatchObj;
            AbstractTaskState.ExceptionMatchImpl exceptionMatch = new AbstractTaskState.ExceptionMatchImpl();
            exceptionMatch.setExceptions((List)exceptionMatchMap.get("Exceptions"));
            exceptionMatch.setNext((String)exceptionMatchMap.get("Next"));
            exceptionMatchList.add(exceptionMatch);
        }
        return exceptionMatchList;
    }
}

