/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.protobuf;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.serializer.protobuf.ProtobufHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ProtobufInnerSerializer {
    private static final ProtobufHelper PROTOBUF_HELPER = new ProtobufHelper();
    private static final String METHOD_TOBYTEARRAY = "toByteArray";
    private static final String METHOD_PARSEFROM = "parseFrom";

    public static byte[] serializeContent(Object request) {
        Class<?> clazz = request.getClass();
        Method method = CollectionUtils.computeIfAbsent(ProtobufInnerSerializer.PROTOBUF_HELPER.toByteArrayMethodMap, clazz, key -> {
            try {
                Method m = clazz.getMethod(METHOD_TOBYTEARRAY, new Class[0]);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
                throw new ShouldNeverHappenException("Cannot found method " + clazz.getName() + ".toByteArray(), please check the generated code.", e);
            }
        });
        try {
            return (byte[])method.invoke(request, new Object[0]);
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException("serialize occurs exception", e);
        }
    }

    public static <T> T deserializeContent(String responseClazz, byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        Class clazz = PROTOBUF_HELPER.getPbClass(responseClazz);
        Method method = CollectionUtils.computeIfAbsent(ProtobufInnerSerializer.PROTOBUF_HELPER.parseFromMethodMap, clazz, key -> {
            try {
                Method m = clazz.getMethod(METHOD_PARSEFROM, byte[].class);
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new ShouldNeverHappenException("Cannot found static method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code");
                }
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                throw new ShouldNeverHappenException("Cannot found method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code", e);
            }
        });
        try {
            return (T)method.invoke(null, new Object[]{content});
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException("Error when invoke " + clazz.getName() + ".parseFrom(byte[]).", e);
        }
    }
}

