/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.seata.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.MergedWarpMessage;
import io.seata.serializer.seata.MessageCodecFactory;
import io.seata.serializer.seata.MessageSeataCodec;
import io.seata.serializer.seata.protocol.AbstractMessageCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MergedWarpMessageCodec
extends AbstractMessageCodec {
    @Override
    public Class<?> getMessageClassType() {
        return MergedWarpMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        MergedWarpMessage mergedWarpMessage = (MergedWarpMessage)t;
        List<AbstractMessage> msgs = mergedWarpMessage.msgs;
        ByteBuf buffer = Unpooled.buffer((int)1024);
        buffer.writeInt(0);
        buffer.writeShort((int)((short)msgs.size()));
        for (AbstractMessage msg : msgs) {
            ByteBuf subBuffer = Unpooled.buffer((int)1024);
            short typeCode = msg.getTypeCode();
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.encode(msg, subBuffer);
            buffer.writeShort((int)msg.getTypeCode());
            buffer.writeBytes(subBuffer);
        }
        int length = buffer.readableBytes();
        byte[] content = new byte[length];
        buffer.setInt(0, length - 4);
        buffer.readBytes(content);
        if (msgs.size() > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one packet:" + msgs.size() + ",buffer size:" + content.length);
        }
        out.writeBytes(content);
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        MergedWarpMessage mergedWarpMessage = (MergedWarpMessage)t;
        if (in.remaining() < 4) {
            return;
        }
        int length = in.getInt();
        if (in.remaining() < length) {
            return;
        }
        byte[] buffer = new byte[length];
        in.get(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.doDecode(mergedWarpMessage, byteBuffer);
    }

    private void doDecode(MergedWarpMessage mergedWarpMessage, ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        ArrayList<AbstractMessage> msgs = new ArrayList<AbstractMessage>();
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            AbstractMessage abstractMessage = MessageCodecFactory.getMessage(typeCode);
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.decode(abstractMessage, byteBuffer);
            msgs.add(abstractMessage);
        }
        mergedWarpMessage.msgs = msgs;
    }
}

