/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.tm.api.DefaultGlobalTransaction;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;

public class GlobalTransactionContext {
    private GlobalTransactionContext() {
    }

    public static GlobalTransaction createNew() {
        return new DefaultGlobalTransaction();
    }

    public static GlobalTransaction getCurrent() {
        String xid = RootContext.getXID();
        if (xid == null) {
            return null;
        }
        return new DefaultGlobalTransaction(xid, GlobalStatus.Begin, GlobalTransactionRole.Participant);
    }

    public static GlobalTransaction getCurrentOrCreate() {
        GlobalTransaction tx = GlobalTransactionContext.getCurrent();
        if (tx == null) {
            return GlobalTransactionContext.createNew();
        }
        return tx;
    }

    public static GlobalTransaction reload(String xid) throws TransactionException {
        return new DefaultGlobalTransaction(xid, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher){

            @Override
            public void begin(int timeout, String name) throws TransactionException {
                throw new IllegalStateException("Never BEGIN on a RELOADED GlobalTransaction. ");
            }
        };
    }
}

