/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.datasource.SeataAutoDataSourceProxyCreator;
import io.seata.spring.annotation.datasource.SeataDataSourceBeanPostProcessor;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.spring.boot.autoconfigure.properties.client.LockProperties;
import io.seata.spring.boot.autoconfigure.properties.client.LogProperties;
import io.seata.spring.boot.autoconfigure.properties.client.RmProperties;
import io.seata.spring.boot.autoconfigure.properties.client.ServiceProperties;
import io.seata.spring.boot.autoconfigure.properties.client.ShutdownProperties;
import io.seata.spring.boot.autoconfigure.properties.client.ThreadFactoryProperties;
import io.seata.spring.boot.autoconfigure.properties.client.TmProperties;
import io.seata.spring.boot.autoconfigure.properties.client.TransportProperties;
import io.seata.spring.boot.autoconfigure.properties.client.UndoProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigApolloProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigConsulProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigCustomProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigEtcd3Properties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigFileProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigNacosProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigProperties;
import io.seata.spring.boot.autoconfigure.properties.config.ConfigZooKeeperProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryConsulProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryCustomProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryEtcd3Properties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryEurekaProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryNacosProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryRedisProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistrySofaProperties;
import io.seata.spring.boot.autoconfigure.properties.registry.RegistryZooKeeperProperties;
import io.seata.spring.boot.autoconfigure.provider.SpringApplicationContextProvider;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@ComponentScan(basePackages={"io.seata.spring.boot.autoconfigure.properties"})
@ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@EnableConfigurationProperties(value={SeataProperties.class})
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    public SeataAutoConfiguration(SeataProperties seataProperties, RmProperties rmProperties, TmProperties tmProperties, LockProperties lockProperties, ServiceProperties serviceProperties, ShutdownProperties shutdownProperties, ThreadFactoryProperties threadFactoryProperties, UndoProperties undoProperties, LogProperties logProperties, TransportProperties transportProperties, ConfigProperties configProperties, ConfigFileProperties configFileProperties, RegistryProperties registryProperties, ConfigNacosProperties configNacosProperties, ConfigConsulProperties configConsulProperties, ConfigZooKeeperProperties configZooKeeperProperties, ConfigApolloProperties configApolloProperties, ConfigEtcd3Properties configEtcd3Properties, ConfigCustomProperties configCustomProperties, RegistryConsulProperties registryConsulProperties, RegistryEtcd3Properties registryEtcd3Properties, RegistryEurekaProperties registryEurekaProperties, RegistryNacosProperties registryNacosProperties, RegistryRedisProperties registryRedisProperties, RegistrySofaProperties registrySofaProperties, RegistryZooKeeperProperties registryZooKeeperProperties, RegistryCustomProperties registryCustomProperties) {
        StarterConstants.PROPERTY_BEAN_MAP.put("seata", seataProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.client.rm", rmProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.client.tm", tmProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.client.rm.lock", lockProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.service", serviceProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.transport.shutdown", shutdownProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.transport.threadFactory", threadFactoryProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.client.undo", undoProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.log", logProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.transport", transportProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config", configProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.file", configFileProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry", registryProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.nacos", configNacosProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.consul", configConsulProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.zk", configZooKeeperProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.apollo", configApolloProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.etcd3", configEtcd3Properties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.config.custom", configCustomProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.consul", registryConsulProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.etcd3", registryEtcd3Properties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.eureka", registryEurekaProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.nacos", registryNacosProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.redis", registryRedisProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.sofa", registrySofaProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.zk", registryZooKeeperProperties);
        StarterConstants.PROPERTY_BEAN_MAP.put("seata.registry.custom", registryCustomProperties);
    }

    @Bean(value={"springApplicationContextProvider"})
    @ConditionalOnMissingBean(name={"springApplicationContextProvider"})
    public SpringApplicationContextProvider springApplicationContextProvider() {
        return new SpringApplicationContextProvider();
    }

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Configuration
    @ConditionalOnProperty(prefix="seata", name={"enableAutoDataSourceProxy", "enable-auto-data-source-proxy"}, havingValue="true", matchIfMissing=true)
    static class SeataDataSourceConfiguration {
        SeataDataSourceConfiguration() {
        }

        @Bean(value={"seataDataSourceBeanPostProcessor"})
        @ConditionalOnMissingBean(value={SeataDataSourceBeanPostProcessor.class})
        public SeataDataSourceBeanPostProcessor seataDataSourceBeanPostProcessor(SeataProperties seataProperties) {
            return new SeataDataSourceBeanPostProcessor(seataProperties.getExcludesForAutoProxying(), seataProperties.getDataSourceProxyMode());
        }

        @Bean(value={"seataAutoDataSourceProxyCreator"})
        @ConditionalOnMissingBean(value={SeataAutoDataSourceProxyCreator.class})
        public SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator(SeataProperties seataProperties) {
            return new SeataAutoDataSourceProxyCreator(seataProperties.isUseJdkProxy(), seataProperties.getExcludesForAutoProxying(), seataProperties.getDataSourceProxyMode());
        }
    }
}

