/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.trace.Trace;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final long serialVersionUID = 3636148327800330130L;
    private MBeanServer server = null;
    private Vector mletList = new Vector();
    private String libraryDirectory;
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private static final String dbgTag = "MLet";
    private transient ClassLoaderRepository currentClr;
    private transient boolean delegateToCLR;
    private Hashtable primitiveClasses = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] uRLArray) {
        this(uRLArray, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this(uRLArray, classLoader, uRLStreamHandlerFactory, true);
    }

    public MLet(URL[] uRLArray, boolean bl) {
        super(uRLArray);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, boolean bl) {
        super(uRLArray, classLoader);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory, boolean bl) {
        super(uRLArray, classLoader, uRLStreamHandlerFactory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.delegateToCLR = bl;
        try {
            this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
            this.libraryDirectory = this.getTmpDir();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void addURL(URL uRL) {
        if (!Arrays.asList(this.getURLs()).contains(uRL)) {
            super.addURL(uRL);
        }
    }

    public void addURL(String string) throws ServiceNotFoundException {
        try {
            URL uRL = new URL(string);
            if (!Arrays.asList(this.getURLs()).contains(uRL)) {
                super.addURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.debug("addURL", string + ": Malformed URL. " + malformedURLException);
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    public URL[] getURLs() {
        return super.getURLs();
    }

    public Set getMBeansFromURL(URL uRL) throws ServiceNotFoundException {
        if (uRL == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(uRL.toString());
    }

    public Set getMBeansFromURL(String string) throws ServiceNotFoundException {
        String string2 = "getMBeansFromURL";
        if (this.server == null) {
            throw new IllegalStateException("This MLet MBean is not registered with an MBeanServer.");
        }
        if (string == null) {
            if (this.isTraceOn()) {
                this.trace(string2, "URL is null");
            }
            throw new ServiceNotFoundException("The specified URL is null");
        }
        string = string.replace(File.separatorChar, '/');
        if (this.isTraceOn()) {
            this.trace(string2, "<URL = " + string + ">");
        }
        MLetParser mLetParser = new MLetParser();
        this.mletList = mLetParser.parseURL(string);
        if (this.mletList == null) {
            if (this.isTraceOn()) {
                this.trace(string2, "Problems while parsing URL " + string);
            }
            throw new ServiceNotFoundException("Problems while parsing URL " + string);
        }
        if (this.mletList.size() == 0) {
            if (this.isTraceOn()) {
                this.trace(string2, "File " + string + " not found or MLET tag not defined in file");
            }
            throw new ServiceNotFoundException("File " + string + " not found or MLET tag not defined in file");
        }
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        Enumeration enumeration = this.mletList.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            MLetContent mLetContent = (MLetContent)enumeration.nextElement();
            String string3 = mLetContent.getCode();
            if (string3 != null && string3.endsWith(".class")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            String string4 = mLetContent.getName();
            URL uRL = mLetContent.getCodeBase();
            String string5 = mLetContent.getVersion();
            String string6 = mLetContent.getSerializedObject();
            String string7 = mLetContent.getJarFiles();
            URL uRL2 = mLetContent.getDocumentBase();
            Map map = mLetContent.getAttributes();
            if (this.isTraceOn()) {
                this.trace(string2, "MLET TAG     = " + map.toString());
                this.trace(string2, "CODEBASE     = " + uRL);
                this.trace(string2, "ARCHIVE      = " + string7);
                this.trace(string2, "CODE         = " + string3);
                this.trace(string2, "OBJECT       = " + string6);
                this.trace(string2, "NAME         = " + string4);
                this.trace(string2, "VERSION      = " + string5);
                this.trace(string2, "DOCUMENT URL = " + uRL2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (this.isTraceOn()) {
                    this.trace(string2, "Load archive for codebase <" + uRL + ">, file <" + (String)object + ">");
                }
                try {
                    uRL = this.check(string5, uRL, (String)object, mLetContent);
                }
                catch (Exception exception) {
                    if (this.isDebugOn()) {
                        this.debug(string2, "check returned exception: " + exception);
                    }
                    hashSet.add(exception);
                    continue;
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(uRL.toString() + (String)object))) continue;
                    this.addURL(uRL + (String)object);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            object = null;
            ObjectInstance objectInstance = null;
            if (string3 != null && string6 != null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "CODE and OBJECT parameters cannot be specified at the same time in tag MLET.");
                }
                hashSet.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (string3 == null && string6 == null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Either CODE or OBJECT parameter must be specified in tag MLET.");
                }
                hashSet.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (string3 != null) {
                    String[] stringArray;
                    Vector vector = new Vector();
                    Vector vector2 = new Vector();
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        stringArray = (String[])iterator.next();
                        if (stringArray.equals("types")) {
                            vector = (Vector)mLetContent.getParameter((String)stringArray);
                        }
                        if (!stringArray.equals("values")) continue;
                        vector2 = (Vector)mLetContent.getParameter((String)stringArray);
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        vector2.setElementAt(this.constructParameter((String)vector2.elementAt(i), (String)vector.elementAt(i)), i);
                    }
                    if (vector.isEmpty()) {
                        objectInstance = string4 == null ? this.server.createMBean(string3, null, this.mletObjectName) : this.server.createMBean(string3, new ObjectName(string4), this.mletObjectName);
                    } else {
                        int n;
                        Object[] objectArray = vector2.toArray();
                        stringArray = new String[vector.size()];
                        for (n = 0; n < stringArray.length; ++n) {
                            stringArray[n] = (String)vector.elementAt(n);
                        }
                        if (this.isDebugOn()) {
                            for (n = 0; n < stringArray.length; ++n) {
                                this.debug(string2, "Signature     = " + stringArray[n]);
                                this.debug(string2, "Params     = " + objectArray[n].toString());
                            }
                        }
                        objectInstance = string4 == null ? this.server.createMBean(string3, null, this.mletObjectName, objectArray, stringArray) : this.server.createMBean(string3, new ObjectName(string4), this.mletObjectName, objectArray, stringArray);
                    }
                } else {
                    object = this.loadSerializedObject(uRL, string6);
                    if (string4 == null) {
                        this.server.registerMBean(object, null);
                    } else {
                        this.server.registerMBean(object, new ObjectName(string4));
                    }
                    objectInstance = new ObjectInstance(string4, object.getClass().getName());
                }
            }
            catch (ReflectionException reflectionException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "ReflectionException: " + reflectionException.getMessage());
                }
                hashSet.add(reflectionException);
                continue;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceAlreadyExistsException: " + instanceAlreadyExistsException.getMessage());
                }
                hashSet.add(instanceAlreadyExistsException);
                continue;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanRegistrationException: " + mBeanRegistrationException.getMessage());
                }
                hashSet.add(mBeanRegistrationException);
                continue;
            }
            catch (MBeanException mBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanException: " + mBeanException.getMessage());
                }
                hashSet.add(mBeanException);
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "NotCompliantMBeanException: " + notCompliantMBeanException.getMessage());
                }
                hashSet.add(notCompliantMBeanException);
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceNotFoundException: " + instanceNotFoundException.getMessage());
                }
                hashSet.add(instanceNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "IOException: " + iOException.getMessage());
                }
                hashSet.add(iOException);
                continue;
            }
            catch (SecurityException securityException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "SecurityException: " + securityException.getMessage());
                }
                hashSet.add(securityException);
                continue;
            }
            catch (Exception exception) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Exception: " + exception.getClass().getName() + exception.getMessage());
                }
                hashSet.add(exception);
                continue;
            }
            catch (Error error) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Error: " + error.getMessage());
                }
                hashSet.add(error);
                continue;
            }
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.setMBeanServer(mBeanServer);
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "type=MLet");
        }
        this.mletObjectName = objectName;
        return this.mletObjectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class loadClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository2 = this.currentClr;
        try {
            Class<?> clazz;
            this.currentClr = classLoaderRepository;
            Class<?> clazz2 = clazz = this.loadClass(string);
            return clazz2;
        }
        finally {
            this.currentClr = classLoaderRepository2;
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, this.currentClr);
    }

    Class findClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        Class clazz = null;
        if (this.isTraceOn()) {
            this.trace("findClass", string);
        }
        try {
            clazz = super.findClass(string);
            if (this.isTraceOn()) {
                this.trace("findClass", "Class " + string + " loaded through mlet classloader");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("findClass", "Class " + string + " not found locally.");
        }
        if (clazz == null && this.delegateToCLR && classLoaderRepository != null) {
            try {
                this.debug("findClass", "Class " + string + ": looking in CLR");
                clazz = classLoaderRepository.loadClassBefore(this, string);
                if (this.isTraceOn()) {
                    this.trace("findClass", "Class " + string + " loaded through the default classloader repository");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.debug("findClass", "Class " + string + " not found in CLR.");
            }
        }
        if (clazz == null) {
            this.debug("findClass", "Failed to load class " + string);
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2;
        String string3 = "findLibrary";
        String string4 = System.mapLibraryName(string);
        if (this.isTraceOn()) {
            this.trace(string3, "Search " + string + " in all JAR files.");
        }
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, string4 + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        string4 = this.removeSpace(System.getProperty("os.name")) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string4;
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, string4 + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        if (this.isTraceOn()) {
            this.trace(string3, string + " not found in any JAR file.");
            this.trace(string3, "Search " + string + " along the path specified as the java.library.path property.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getTmpDir() {
        String string;
        File file;
        block17: {
            File file2;
            block15: {
                String string2;
                block16: {
                    block13: {
                        String string3;
                        block14: {
                            String string4 = System.getProperty("java.io.tmpdir");
                            if (string4 != null) {
                                return string4;
                            }
                            file = null;
                            file = File.createTempFile("tmp", "jmx");
                            if (file != null) break block13;
                            string3 = null;
                            Object var6_6 = null;
                            if (file == null) break block14;
                            try {
                                file.delete();
                            }
                            catch (Exception exception) {
                                this.debug("getTmpDir", "Failed to delete temporary file: " + exception.getMessage());
                            }
                        }
                        return string3;
                    }
                    file2 = file.getParentFile();
                    if (file2 != null) break block15;
                    string2 = null;
                    Object var6_7 = null;
                    if (file == null) break block16;
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        this.debug("getTmpDir", "Failed to delete temporary file: " + exception.getMessage());
                    }
                }
                return string2;
            }
            string = file2.getAbsolutePath();
            Object var6_8 = null;
            if (file == null) break block17;
            try {
                file.delete();
            }
            catch (Exception exception) {
                this.debug("getTmpDir", "Failed to delete temporary file: " + exception.getMessage());
            }
        }
        return string;
        catch (Exception exception) {
            String string5;
            block18: {
                try {
                    this.debug("getTmpDir", "Failed to determine system temporary dir.");
                    string5 = null;
                    Object var6_9 = null;
                    if (file == null) break block18;
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var6_10 = null;
                        if (file == null) break block19;
                        try {
                            file.delete();
                        }
                        catch (Exception exception2) {
                            this.debug("getTmpDir", "Failed to delete temporary file: " + exception2.getMessage());
                        }
                    }
                    throw throwable;
                }
                try {
                    file.delete();
                }
                catch (Exception exception3) {
                    this.debug("getTmpDir", "Failed to delete temporary file: " + exception3.getMessage());
                }
            }
            return string5;
        }
    }

    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream;
            File file = new File(this.libraryDirectory, string);
            if (file.exists()) {
                file.delete();
            }
            if ((inputStream = this.getResourceAsStream(string.replace(File.separatorChar, '/'))) != null) {
                int n;
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            this.debug("loadLibraryAsResource", string + ": Failed to load library. " + exception);
            return null;
        }
        return null;
    }

    private String removeSpace(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        while (n != -1) {
            n = (string = string.substring(n2)).indexOf(32);
            string2 = n != -1 ? string2 + string.substring(0, n) : string2 + string.substring(0);
            n2 = n + 1;
        }
        return string2;
    }

    protected URL check(String string, URL uRL, String string2, MLetContent mLetContent) throws Exception {
        return uRL;
    }

    private Object loadSerializedObject(URL uRL, String string) throws IOException, ClassNotFoundException {
        InputStream inputStream;
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        if (this.isTraceOn()) {
            this.trace("loadSerializedObject", uRL.toString() + string);
        }
        if ((inputStream = this.getResourceAsStream(string)) != null) {
            try {
                MLetObjectInputStream mLetObjectInputStream = new MLetObjectInputStream(inputStream, this);
                Object object = mLetObjectInputStream.readObject();
                mLetObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + iOException.getMessage());
                }
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + classNotFoundException.getMessage());
                }
                throw classNotFoundException;
            }
        }
        if (this.isDebugOn()) {
            this.debug("loadSerializedObject", "Error: File " + string + " containing serialized object not found");
        }
        throw new Error("File " + string + " containing serialized object not found");
    }

    private Object constructParameter(String string, String string2) {
        block11: {
            Class clazz = (Class)this.primitiveClasses.get(string2);
            if (clazz != null) {
                try {
                    Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = MLet.class$("java.lang.String")) : class$java$lang$String);
                    Object[] objectArray = new Object[]{string};
                    return constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug(dbgTag, "constructParameter", "Unexpected Exception" + exception.getClass().getName() + " occured");
                }
            }
        }
        if (string2.compareTo("java.lang.Boolean") == 0) {
            return new Boolean(string);
        }
        if (string2.compareTo("java.lang.Byte") == 0) {
            return new Byte(string);
        }
        if (string2.compareTo("java.lang.Short") == 0) {
            return new Short(string);
        }
        if (string2.compareTo("java.lang.Long") == 0) {
            return new Long(string);
        }
        if (string2.compareTo("java.lang.Integer") == 0) {
            return new Integer(string);
        }
        if (string2.compareTo("java.lang.Float") == 0) {
            return new Float(string);
        }
        if (string2.compareTo("java.lang.Double") == 0) {
            return new Double(string);
        }
        if (string2.compareTo("java.lang.String") == 0) {
            return string;
        }
        return string;
    }

    private synchronized void setMBeanServer(final MBeanServer mBeanServer) {
        this.server = mBeanServer;
        this.currentClr = (ClassLoaderRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return mBeanServer.getClassLoaderRepository();
            }
        });
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)2, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)2, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

