/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webapi.sdk;

import com.kingdee.bos.webapi.entity.Cookie;
import com.kingdee.bos.webapi.entity.RequestBodyObject;
import com.kingdee.bos.webapi.utils.HttpUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpRequester {
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    int connectTimeout = 120;
    RequestBodyObject reqJson;
    int requestTimeout = 120;
    String url;
    Map<String, String> header;
    int statusCode;
    Set<Cookie> repoCookies;

    public HttpRequester(String url, Map<String, String> header, RequestBodyObject reqJson) {
        this.url = url;
        this.header = header;
        this.reqJson = reqJson;
    }

    public HttpRequester(String url, Map<String, String> header, RequestBodyObject reqJson, int connectTimeout, int requestTimeout) {
        this.url = url;
        this.header = header;
        this.reqJson = reqJson;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldFactory;
    }

    public String post() throws Exception {
        String result;
        block13: {
            PrintWriter out = null;
            result = "";
            URL realUrl = new URL(this.url);
            HttpURLConnection conn = null;
            Proxy proxy = HttpUtils.getProxy();
            conn = proxy != null ? (HttpURLConnection)realUrl.openConnection(proxy) : (HttpURLConnection)realUrl.openConnection();
            boolean useHttps = this.url.startsWith("https");
            if (useHttps) {
                HttpsURLConnection https = (HttpsURLConnection)conn;
                HttpRequester.trustAllHosts(https);
                https.setHostnameVerifier(DO_NOT_VERIFY);
            }
            conn.setConnectTimeout(this.getConnectTimeout() * 1000);
            conn.setReadTimeout(this.getRequestTimeout() * 1000);
            if (this.header != null) {
                for (Map.Entry entry : this.header.entrySet()) {
                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            conn.setRequestProperty("Content-type", "applicatin/json");
            conn.setRequestProperty("User-Agent", "Kingdee/Java WebApi SDK 8.0.6 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            try {
                int statusCode;
                if (this.reqJson != null) {
                    out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8));
                    out.print(this.reqJson.toJson());
                    out.flush();
                }
                InputStream inputStream = (statusCode = conn.getResponseCode()) < 400 ? conn.getInputStream() : conn.getErrorStream();
                result = this.readRepoBody(inputStream);
                if (statusCode < 400) {
                    for (Map.Entry<String, List<String>> cookie : conn.getHeaderFields().entrySet()) {
                        if (cookie.getKey() == null || !cookie.getKey().equals("Set-Cookie")) continue;
                        this.repoCookies = new HashSet<Cookie>();
                        for (String c : cookie.getValue()) {
                            Cookie ck = Cookie.parse(c);
                            if (ck == null) continue;
                            this.repoCookies.add(new Cookie(c));
                        }
                    }
                    break block13;
                }
                throw new Exception(String.format("StatusCode:%s, Desc:%s", statusCode, result));
            }
            catch (Exception er) {
                throw er;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return result;
    }

    String readRepoBody(InputStream inputStream) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        return sb.toString();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public RequestBodyObject getReqJson() {
        return this.reqJson;
    }

    public void setReqJson(RequestBodyObject reqJson) {
        this.reqJson = reqJson;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Set<Cookie> getRepoCookies() {
        return this.repoCookies;
    }

    public void setRepoCookies(Set<Cookie> repoCookies) {
        this.repoCookies = repoCookies;
    }
}

