/*
 * Decompiled with CFR 0.152.
 */
package nccloud.api.test.utils;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import nccloud.api.test.utils.Base64Util;
import nccloud.api.test.utils.KeysFactory;

public class Decryption {
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String symDecrypt(String strkey, String src) throws Exception {
        String target = null;
        try {
            Key key = KeysFactory.getSymKey(strkey);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] decodeResult = cipher.doFinal(Base64Util.decryptBASE64(src));
            target = new String(decodeResult);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            throw new Exception("\u89e3\u5bc6\u5931\u8d25" + e.getMessage());
        }
        return target;
    }

    public static String priDecrypt(String priKey, String src) throws Exception {
        String target = null;
        try (ByteArrayOutputStream out = null;){
            try {
                Key key = KeysFactory.getPrivateKey(priKey);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, key);
                byte[] data = Base64Util.decryptBASE64(src);
                int inputLen = data.length;
                out = new ByteArrayOutputStream();
                int offSet = 0;
                int i = 0;
                while (inputLen - offSet > 0) {
                    byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(data, offSet, 128) : cipher.doFinal(data, offSet, inputLen - offSet);
                    out.write(cache, 0, cache.length);
                    offSet = ++i * 128;
                }
                target = new String(out.toByteArray());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
                throw new Exception("\u89e3\u5bc6\u5931\u8d25" + e.getMessage());
            }
        }
        return target;
    }
}

