/*
 * Decompiled with CFR 0.152.
 */
package nccloud.api.testcase.base;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nccloud.api.test.utils.CompressUtil;
import nccloud.api.test.utils.Decryption;
import nccloud.api.test.utils.Encryption;
import nccloud.api.test.utils.ResultMessageUtil;
import nccloud.api.test.utils.SHA256Util;
import org.apache.commons.lang3.StringUtils;

public class Test4 {
    private static String client_secret = null;
    private static String pubKey = null;
    private static String client_id = null;
    private static String username = null;
    private static String pwd = null;
    private static String busi_center = null;
    private static String grant_type = null;
    private static String baseUrl = null;
    private static String secret_level = null;
    private static String requestBody = null;
    private static String apiUrl = null;
    public static String token = null;
    public static String repeat_check = null;
    public static String busi_id = null;

    public static JSONObject getSupplier() {
        JSONObject supplier = new JSONObject();
        JSONObject ufinterface = new JSONObject();
        supplier.put("ufinterface", (Object)ufinterface);
        ufinterface.put("account", (Object)"1");
        ufinterface.put("billtype", (Object)"supplier");
        ufinterface.put("groupcode", (Object)"1");
        ufinterface.put("isexchange", (Object)"Y");
        ufinterface.put("replace", (Object)"Y");
        ufinterface.put("sender", (Object)"b2b");
        JSONObject bill = new JSONObject();
        ufinterface.put("bill", (Object)bill);
        JSONObject billhead = new JSONObject();
        bill.put("billhead", (Object)billhead);
        billhead.put("pk_group", (Object)"1");
        billhead.put("pk_org", (Object)"01");
        billhead.put("pk_supplierclass", (Object)"201");
        billhead.put("code", (Object)"2015119");
        billhead.put("def12", (Object)"4893753454");
        billhead.put("name", (Object)"test345");
        billhead.put("shortname", (Object)"test345");
        billhead.put("enablestate", (Object)"2");
        billhead.put("iscustomer", (Object)"Y");
        billhead.put("mnecode", (Object)"37295224295956");
        billhead.put("supprop", (Object)"0");
        billhead.put("taxpayerid", (Object)"37295224295958");
        billhead.put("tel1", (Object)"13088529943");
        billhead.put("pk_timezone", (Object)"P0800");
        billhead.put("pk_format", (Object)"ZH-CN");
        billhead.put("pk_country", (Object)"CN");
        billhead.put("corpaddress", (Object)"");
        billhead.put("pk_linkman", (Object)"");
        JSONObject suplinkman = new JSONObject();
        billhead.put("suplinkman", (Object)suplinkman);
        suplinkman.put("pk_linkman", (Object)"");
        JSONObject enterpriseAddress = new JSONObject();
        billhead.put("\u4f01\u4e1a\u5730\u5740", (Object)enterpriseAddress);
        enterpriseAddress.put("city", (Object)"\u6d4e\u5357");
        enterpriseAddress.put("country", (Object)"CN");
        enterpriseAddress.put("province", (Object)"\u5c71\u4e1c\u7701");
        return supplier;
    }

    public static void main(String[] args) {
        try {
            Test4.init();
            token = Test4.getToken();
            System.out.println("getTokenData:" + token);
            JSONObject supplier = Test4.getSupplier();
            String s = supplier.toJSONString();
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getToken() throws Exception {
        String token = null;
        if ("password".equals(grant_type)) {
            token = Test4.getTokenByPWD();
        } else if ("client_credentials".equals(grant_type)) {
            token = Test4.getTokenByClient();
        }
        return token;
    }

    private static String getTokenByClient() throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grant_type", "client_credentials");
        paramMap.put("client_id", client_id);
        paramMap.put("client_secret", URLEncoder.encode(Encryption.pubEncrypt(pubKey, client_secret), "utf-8"));
        paramMap.put("biz_center", busi_center);
        String sign = SHA256Util.getSHA256(String.valueOf(client_id) + client_secret + pubKey);
        paramMap.put("signature", sign);
        String url = String.valueOf(baseUrl) + "/nccloud/opm/accesstoken";
        String mediaType = "application/x-www-form-urlencoded";
        String token = Test4.doPost(url, paramMap, mediaType, null, "");
        return token;
    }

    private static String getTokenByPWD() throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grant_type", "password");
        paramMap.put("client_id", client_id);
        paramMap.put("client_secret", URLEncoder.encode(Encryption.pubEncrypt(pubKey, client_secret), "utf-8"));
        paramMap.put("username", username);
        paramMap.put("password", URLEncoder.encode(Encryption.pubEncrypt(pubKey, pwd), "utf-8"));
        paramMap.put("biz_center", busi_center);
        String sign = SHA256Util.getSHA256(String.valueOf(client_id) + client_secret + username + pwd + pubKey);
        paramMap.put("signature", sign);
        String url = String.valueOf(baseUrl) + "/nccloud/opm/accesstoken";
        String mediaType = "application/x-www-form-urlencoded";
        String token = Test4.doPost(url, paramMap, mediaType, null, "");
        return token;
    }

    private static String testApi(String token, String apiUrl, String requestBody) throws Exception {
        ResultMessageUtil returnData = (ResultMessageUtil)new Gson().fromJson(token, ResultMessageUtil.class);
        Map data = (Map)returnData.getData();
        String access_token = (String)data.get("access_token");
        String security_key = (String)data.get("security_key");
        String refresh_token = (String)data.get("refresh_token");
        System.out.println("ACCESS_TOKEN:" + access_token);
        String url = String.valueOf(baseUrl) + apiUrl;
        HashMap<String, String> headermap = new HashMap<String, String>();
        headermap.put("access_token", access_token);
        headermap.put("client_id", client_id);
        StringBuffer sb = new StringBuffer();
        sb.append(client_id);
        if (StringUtils.isNotBlank((CharSequence)requestBody)) {
            sb.append(requestBody);
        }
        sb.append(pubKey);
        String sign = SHA256Util.getSHA256(sb.toString());
        System.out.println(sb);
        headermap.put("signature", sign);
        if (StringUtils.isNotBlank((CharSequence)busi_id)) {
            headermap.put("busi_id", busi_id);
        }
        if (StringUtils.isNotBlank((CharSequence)repeat_check)) {
            headermap.put("repeat_check", repeat_check);
        }
        headermap.put("ucg_flag", "y");
        String mediaType = "application/json;charset=utf-8";
        String json = Test4.dealRequestBody(requestBody, security_key, secret_level);
        String result = Test4.doPost(url, null, mediaType, headermap, json);
        String result2DecryptAndDecompress = Test4.dealResponseBody(result, security_key, secret_level);
        System.out.println("RESULT:" + result);
        System.out.println(result2DecryptAndDecompress);
        return result2DecryptAndDecompress;
    }

    private static String dealResponseBody(String source, String security_key, String level) throws Exception {
        String result = null;
        if (StringUtils.isEmpty((CharSequence)level) || "L0".equals(level)) {
            result = source;
        } else if ("L1".equals(level)) {
            result = Decryption.symDecrypt(security_key, source);
        } else if ("L2".equals(level)) {
            result = CompressUtil.gzipDecompress(source);
        } else if ("L3".equals(level)) {
            result = CompressUtil.gzipDecompress(Decryption.symDecrypt(security_key, source));
        } else if ("L4".equals(level)) {
            result = Decryption.symDecrypt(security_key, CompressUtil.gzipDecompress(source));
        } else {
            throw new Exception("\u65e0\u6548\u7684\u5b89\u5168\u7b49\u7ea7");
        }
        return result;
    }

    private static void init() {
        Properties properties = new Properties();
        String filepath = "config.properties";
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classloader.getResourceAsStream(filepath);
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            properties.load(reader);
            client_secret = new String(properties.getProperty("client_secret").getBytes("utf-8"), "utf-8");
            client_id = properties.getProperty("client_id");
            pubKey = properties.getProperty("pubKey");
            username = properties.getProperty("username");
            pwd = properties.getProperty("pwd");
            busi_center = properties.getProperty("busi_center");
            baseUrl = properties.getProperty("baseUrl");
            requestBody = new String(properties.getProperty("requestBody").getBytes("utf-8"), "utf-8");
            apiUrl = properties.getProperty("apiUrl");
            grant_type = properties.getProperty("grant_type");
            secret_level = properties.getProperty("secret_level");
            repeat_check = properties.getProperty("repeat_check");
            busi_id = properties.getProperty("busi_id");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String dealRequestBody(String source, String security_key, String level) throws Exception {
        String result = null;
        if (StringUtils.isEmpty((CharSequence)level) || "L0".equals(level)) {
            result = source;
        } else if ("L1".equals(level)) {
            result = Encryption.symEncrypt(security_key, source);
        } else if ("L2".equals(level)) {
            result = CompressUtil.gzipCompress(source);
        } else if ("L3".equals(level)) {
            result = Encryption.symEncrypt(security_key, CompressUtil.gzipCompress(source));
        } else if ("L4".equals(level)) {
            result = CompressUtil.gzipCompress(Encryption.symEncrypt(security_key, source));
        } else {
            throw new Exception("\u65e0\u6548\u7684\u5b89\u5168\u7b49\u7ea7");
        }
        return result;
    }

    private static String doPost(String baseUrl, Map<String, String> paramMap, String mediaType, Map<String, String> headers, String json) {
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        OutputStream out = null;
        BufferedReader bufferedReader = null;
        String result = null;
        try {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(baseUrl);
                if (paramMap != null) {
                    sb.append("?");
                    for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        sb.append(String.valueOf(key) + "=" + value).append("&");
                    }
                    baseUrl = sb.toString().substring(0, sb.toString().length() - 1);
                }
                URL urlObj = new URL(baseUrl);
                urlConnection = (HttpURLConnection)urlObj.openConnection();
                urlConnection.setConnectTimeout(50000);
                urlConnection.setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setUseCaches(false);
                urlConnection.addRequestProperty("content-type", mediaType);
                if (headers != null) {
                    for (String key : headers.keySet()) {
                        urlConnection.addRequestProperty(key, headers.get(key));
                    }
                }
                out = urlConnection.getOutputStream();
                out.write(json.getBytes("utf-8"));
                out.flush();
                int resCode = urlConnection.getResponseCode();
                in = resCode == 200 || resCode == 201 || resCode == 202 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
                bufferedReader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                StringBuffer temp = new StringBuffer();
                String line = bufferedReader.readLine();
                while (line != null) {
                    temp.append(line).append("\r\n");
                    line = bufferedReader.readLine();
                }
                String ecod = urlConnection.getContentEncoding();
                if (ecod == null) {
                    ecod = Charset.forName("utf-8").name();
                }
                result = new String(temp.toString().getBytes("utf-8"), ecod);
            }
            catch (Exception e) {
                System.out.println(e);
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                urlConnection.disconnect();
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            urlConnection.disconnect();
        }
        return result;
    }

    class SecretConst {
        public static final String LEVEL0 = "L0";
        public static final String LEVEL1 = "L1";
        public static final String LEVEL2 = "L2";
        public static final String LEVEL3 = "L3";
        public static final String LEVEL4 = "L4";

        SecretConst() {
        }
    }
}

