/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cms;

import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DEREncodableVector;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.cms.Attribute;
import java.util.Hashtable;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = new Hashtable(hashtable);
    }

    public AttributeTable(DEREncodableVector dEREncodableVector) {
        int n = 0;
        while (n != dEREncodableVector.size()) {
            Attribute attribute = Attribute.getInstance(dEREncodableVector.get(n));
            this.attributes.put(attribute.getAttrType(), attribute);
            ++n;
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        int n = 0;
        while (n != aSN1Set.size()) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(n));
            this.attributes.put(attribute.getAttrType(), attribute);
            ++n;
        }
    }

    public Attribute get(DERObjectIdentifier dERObjectIdentifier) {
        return (Attribute)this.attributes.get(dERObjectIdentifier);
    }

    public Hashtable toHashtable() {
        return new Hashtable(this.attributes);
    }
}

