/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cms;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.X509Name;
import java.math.BigInteger;

public class IssuerAndSerialNumber
extends ASN1Encodable {
    X509Name name;
    DERInteger serialNumber;

    public static IssuerAndSerialNumber getInstance(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IssuerAndSerialNumber((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Illegal object in IssuerAndSerialNumber: " + object.getClass().getName());
    }

    public IssuerAndSerialNumber(ASN1Sequence aSN1Sequence) {
        this.name = X509Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.serialNumber = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public IssuerAndSerialNumber(X509Name x509Name, BigInteger bigInteger) {
        this.name = x509Name;
        this.serialNumber = new DERInteger(bigInteger);
    }

    public IssuerAndSerialNumber(X509Name x509Name, DERInteger dERInteger) {
        this.name = x509Name;
        this.serialNumber = dERInteger;
    }

    public X509Name getName() {
        return this.name;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.name);
        aSN1EncodableVector.add(this.serialNumber);
        return new DERSequence(aSN1EncodableVector);
    }
}

