/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cms;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.cms.RecipientIdentifier;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;

public class KeyTransRecipientInfo
extends ASN1Encodable {
    private DERInteger version;
    private RecipientIdentifier rid;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1OctetString encryptedKey;

    public KeyTransRecipientInfo(RecipientIdentifier recipientIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        this.version = recipientIdentifier.getDERObject() instanceof ASN1TaggedObject ? new DERInteger(2) : new DERInteger(0);
        this.rid = recipientIdentifier;
        this.keyEncryptionAlgorithm = algorithmIdentifier;
        this.encryptedKey = aSN1OctetString;
    }

    public KeyTransRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.version = (DERInteger)aSN1Sequence.getObjectAt(0);
        this.rid = RecipientIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
        this.encryptedKey = (ASN1OctetString)aSN1Sequence.getObjectAt(3);
    }

    public static KeyTransRecipientInfo getInstance(Object object) {
        if (object == null || object instanceof KeyTransRecipientInfo) {
            return (KeyTransRecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KeyTransRecipientInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Illegal object in KeyTransRecipientInfo: " + object.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        return this.rid;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.encryptedKey;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.rid);
        aSN1EncodableVector.add(this.keyEncryptionAlgorithm);
        aSN1EncodableVector.add(this.encryptedKey);
        return new DERSequence(aSN1EncodableVector);
    }
}

