/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cms;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSequence;

public class OtherRecipientInfo
extends ASN1Encodable {
    private DERObjectIdentifier oriType;
    private DEREncodable oriValue;

    public OtherRecipientInfo(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.oriType = dERObjectIdentifier;
        this.oriValue = dEREncodable;
    }

    public OtherRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.oriType = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.oriValue = aSN1Sequence.getObjectAt(2);
    }

    public static OtherRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return OtherRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static OtherRecipientInfo getInstance(Object object) {
        if (object == null || object instanceof OtherRecipientInfo) {
            return (OtherRecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new OtherRecipientInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid OtherRecipientInfo: " + object.getClass().getName());
    }

    public DERObjectIdentifier getType() {
        return this.oriType;
    }

    public DEREncodable getValue() {
        return this.oriValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.oriType);
        aSN1EncodableVector.add(this.oriValue);
        return new DERSequence(aSN1EncodableVector);
    }
}

