/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.ocsp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSequence;

public class ResponseBytes
extends ASN1Encodable {
    DERObjectIdentifier responseType;
    ASN1OctetString response;

    public ResponseBytes(DERObjectIdentifier dERObjectIdentifier, ASN1OctetString aSN1OctetString) {
        this.responseType = dERObjectIdentifier;
        this.response = aSN1OctetString;
    }

    public ResponseBytes(ASN1Sequence aSN1Sequence) {
        this.responseType = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.response = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
    }

    public static ResponseBytes getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponseBytes.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ResponseBytes getInstance(Object object) {
        if (object == null || object instanceof ResponseBytes) {
            return (ResponseBytes)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ResponseBytes((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObjectIdentifier getResponseType() {
        return this.responseType;
    }

    public ASN1OctetString getResponse() {
        return this.response;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.responseType);
        aSN1EncodableVector.add(this.response);
        return new DERSequence(aSN1EncodableVector);
    }
}

