/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.ocsp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DEREnumerated;
import cn.com.infosec.asn1.DERGeneralizedTime;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x509.CRLReason;

public class RevokedInfo
extends ASN1Encodable {
    private DERGeneralizedTime revocationTime;
    private CRLReason revocationReason;

    public RevokedInfo(DERGeneralizedTime dERGeneralizedTime, CRLReason cRLReason) {
        this.revocationTime = dERGeneralizedTime;
        this.revocationReason = cRLReason;
    }

    public RevokedInfo(ASN1Sequence aSN1Sequence) {
        this.revocationTime = (DERGeneralizedTime)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.revocationReason = new CRLReason(DEREnumerated.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
        }
    }

    public static RevokedInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RevokedInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RevokedInfo getInstance(Object object) {
        if (object == null || object instanceof RevokedInfo) {
            return (RevokedInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RevokedInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERGeneralizedTime getRevocationTime() {
        return this.revocationTime;
    }

    public CRLReason getRevocationReason() {
        return this.revocationReason;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.revocationTime);
        if (this.revocationReason != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.revocationReason));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

