/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.pkcs.EncryptionScheme;
import cn.com.infosec.asn1.pkcs.KeyDerivationFunc;
import cn.com.infosec.asn1.pkcs.PBKDF2Params;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class PBES2Parameters
extends ASN1Encodable
implements PKCSObjectIdentifiers {
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Parameters(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
        this.func = aSN1Sequence2.getObjectAt(0).equals(PKCSObjectIdentifiers.id_PBKDF2) ? new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, PBKDF2Params.getInstance(aSN1Sequence2.getObjectAt(1))) : new KeyDerivationFunc(aSN1Sequence2);
        this.scheme = new EncryptionScheme((ASN1Sequence)enumeration.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.func);
        aSN1EncodableVector.add(this.scheme);
        return new DERSequence(aSN1EncodableVector);
    }
}

