/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class PBKDF2Params
extends ASN1Encodable {
    ASN1OctetString octStr;
    DERInteger iterationCount;
    DERInteger keyLength;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PBKDF2Params((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PBKDF2Params(byte[] byArray, int n) {
        this.octStr = new DEROctetString(byArray);
        this.iterationCount = new DERInteger(n);
    }

    public PBKDF2Params(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.octStr = (ASN1OctetString)enumeration.nextElement();
        this.iterationCount = (DERInteger)enumeration.nextElement();
        this.keyLength = enumeration.hasMoreElements() ? (DERInteger)enumeration.nextElement() : null;
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.octStr);
        aSN1EncodableVector.add(this.iterationCount);
        if (this.keyLength != null) {
            aSN1EncodableVector.add(this.keyLength);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

