/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.misc.CAST5CBCParameters;
import cn.com.infosec.asn1.misc.IDEACBCPar;
import cn.com.infosec.asn1.misc.NetscapeCertType;
import cn.com.infosec.asn1.misc.NetscapeRevocationURL;
import cn.com.infosec.asn1.misc.VerisignCzagExtension;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class MiscTest
implements Test {
    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{new CAST5CBCParameters(byArray, 128), new NetscapeCertType(32), new VerisignCzagExtension(new DERIA5String("hello")), new IDEACBCPar(byArray), new NetscapeRevocationURL(new DERIA5String("http://test"))};
        byte[] byArray2 = Base64.decode("MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            int n = 0;
            while (n != aSN1EncodableArray.length) {
                aSN1OutputStream.writeObject(aSN1EncodableArray[n]);
                ++n;
            }
            DERObject[] dERObjectArray = new DERObject[aSN1EncodableArray.length];
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), byArray2)) {
                return new SimpleTestResult(false, this.getName() + ": Failed data check");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            int n2 = 0;
            while (n2 != aSN1EncodableArray.length) {
                DERObject dERObject = aSN1InputStream.readObject();
                if (!aSN1EncodableArray[n2].equals(dERObject)) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + dERObject);
                }
                if (dERObject.hashCode() != aSN1EncodableArray[n2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + dERObject);
                }
                ++n2;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "Misc";
    }

    public static void main(String[] stringArray) {
        MiscTest miscTest = new MiscTest();
        TestResult testResult = miscTest.perform();
        System.out.println(testResult);
    }
}

