/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERGeneralizedTime;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.cms.RecipientKeyIdentifier;
import cn.com.infosec.asn1.smime.SMIMECapabilitiesAttribute;
import cn.com.infosec.asn1.smime.SMIMECapability;
import cn.com.infosec.asn1.smime.SMIMECapabilityVector;
import cn.com.infosec.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.util.Date;

public class SMIMETest
implements Test {
    byte[] attrBytes = Base64.decode("MDQGCSqGSIb3DQEJDzEnMCUwCgYIKoZIhvcNAwcwDgYIKoZIhvcNAwICAgCAMAcGBSsOAwIH");
    byte[] prefBytes = Base64.decode("MCwGCyqGSIb3DQEJEAILMR2hGwQIAAAAAAAAAAAYDzE5NzAwMTAxMDAwMDAxWg==");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
        SMIMECapabilitiesAttribute sMIMECapabilitiesAttribute = new SMIMECapabilitiesAttribute(sMIMECapabilityVector);
        SMIMEEncryptionKeyPreferenceAttribute sMIMEEncryptionKeyPreferenceAttribute = new SMIMEEncryptionKeyPreferenceAttribute(new RecipientKeyIdentifier(new DEROctetString(new byte[8]), new DERGeneralizedTime(new Date(1000L)), null));
        try {
            if (!this.isSameAs(sMIMECapabilitiesAttribute.getEncoded(), this.attrBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.attrBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            if (!sMIMECapabilitiesAttribute.equals(dERObject)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for attr");
            }
            if (!this.isSameAs(sMIMEEncryptionKeyPreferenceAttribute.getEncoded(), this.prefBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            byteArrayInputStream = new ByteArrayInputStream(this.prefBytes);
            aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            dERObject = aSN1InputStream.readObject();
            if (!sMIMEEncryptionKeyPreferenceAttribute.equals(dERObject)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for pref");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "SMIME";
    }

    public static void main(String[] stringArray) {
        SMIMETest sMIMETest = new SMIMETest();
        TestResult testResult = sMIMETest.perform();
        System.out.println(testResult);
    }
}

