/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.DERUTF8String;
import cn.com.infosec.asn1.x509.GeneralNames;
import java.util.Enumeration;
import java.util.Vector;

public class IetfAttrSyntax
extends ASN1Encodable {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    Vector values = new Vector();
    int valueChoice = -1;

    public IetfAttrSyntax(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), false);
            ++n;
        } else if (aSN1Sequence.size() == 2) {
            this.policyAuthority = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
            ++n;
        }
        if (!(aSN1Sequence.getObjectAt(n) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(n);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            int n2;
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (dERObject instanceof DERObjectIdentifier) {
                n2 = 2;
            } else if (dERObject instanceof DERUTF8String) {
                n2 = 3;
            } else if (dERObject instanceof DEROctetString) {
                n2 = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.valueChoice < 0) {
                this.valueChoice = n2;
            }
            if (n2 != this.valueChoice) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.values.addElement(dERObject);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public Object[] getValues() {
        if (this.getValueType() == 1) {
            Object[] objectArray = new ASN1OctetString[this.values.size()];
            int n = 0;
            while (n != objectArray.length) {
                objectArray[n] = (ASN1OctetString)this.values.elementAt(n);
                ++n;
            }
            return objectArray;
        }
        if (this.getValueType() == 2) {
            Object[] objectArray = new DERObjectIdentifier[this.values.size()];
            int n = 0;
            while (n != objectArray.length) {
                objectArray[n] = (DERObjectIdentifier)this.values.elementAt(n);
                ++n;
            }
            return objectArray;
        }
        Object[] objectArray = new DERUTF8String[this.values.size()];
        int n = 0;
        while (n != objectArray.length) {
            objectArray[n] = (DERUTF8String)this.values.elementAt(n);
            ++n;
        }
        return objectArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.policyAuthority));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Enumeration enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector2.add((ASN1Encodable)enumeration.nextElement());
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

