/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x509.GeneralNames;
import cn.com.infosec.asn1.x509.IssuerSerial;
import cn.com.infosec.asn1.x509.ObjectDigestInfo;

public class V2Form
extends ASN1Encodable {
    GeneralNames issuerName;
    IssuerSerial baseCertificateID;
    ObjectDigestInfo objectDigestInfo;

    public static V2Form getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return V2Form.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static V2Form getInstance(Object object) {
        if (object == null || object instanceof V2Form) {
            return (V2Form)object;
        }
        if (object instanceof ASN1Sequence) {
            return new V2Form((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public V2Form(GeneralNames generalNames) {
        this.issuerName = generalNames;
    }

    public V2Form(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (!(aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject)) {
            ++n;
            this.issuerName = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
        }
        int n2 = n;
        while (n2 != aSN1Sequence.size()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n2);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.baseCertificateID = IssuerSerial.getInstance(aSN1TaggedObject, false);
            } else if (aSN1TaggedObject.getTagNo() == 1) {
                this.objectDigestInfo = ObjectDigestInfo.getInstance(aSN1TaggedObject, false);
            }
            ++n2;
        }
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.issuerName != null) {
            aSN1EncodableVector.add(this.issuerName);
        }
        if (this.baseCertificateID != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.baseCertificateID));
        }
        if (this.objectDigestInfo != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.objectDigestInfo));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

