/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x9;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x9.X9Curve;
import cn.com.infosec.asn1.x9.X9ECPoint;
import cn.com.infosec.asn1.x9.X9FieldID;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;

public class X9ECParameters
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private X9FieldID fieldID;
    private ECCurve curve;
    private ECPoint g;
    private BigInteger n;
    private BigInteger h;
    private byte[] seed;

    public X9ECParameters(ASN1Sequence aSN1Sequence) {
        if (!(aSN1Sequence.getObjectAt(0) instanceof DERInteger) || !((DERInteger)aSN1Sequence.getObjectAt(0)).getValue().equals(ONE)) {
            throw new IllegalArgumentException("bad version in X9ECParameters");
        }
        X9Curve x9Curve = new X9Curve(new X9FieldID((ASN1Sequence)aSN1Sequence.getObjectAt(1)), (ASN1Sequence)aSN1Sequence.getObjectAt(2));
        this.curve = x9Curve.getCurve();
        this.g = new X9ECPoint(this.curve, (ASN1OctetString)aSN1Sequence.getObjectAt(3)).getPoint();
        this.n = ((DERInteger)aSN1Sequence.getObjectAt(4)).getValue();
        this.seed = x9Curve.getSeed();
        this.h = aSN1Sequence.size() == 6 ? ((DERInteger)aSN1Sequence.getObjectAt(5)).getValue() : ONE;
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        this(eCCurve, eCPoint, bigInteger, ONE, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.curve = eCCurve;
        this.g = eCPoint;
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = byArray;
        this.fieldID = eCCurve instanceof ECCurve.Fp ? new X9FieldID(X9ObjectIdentifiers.prime_field, ((ECCurve.Fp)eCCurve).getQ()) : new X9FieldID(X9ObjectIdentifiers.characteristic_two_field, null);
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.g;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(1));
        aSN1EncodableVector.add(this.fieldID);
        aSN1EncodableVector.add(new X9Curve(this.curve, this.seed));
        aSN1EncodableVector.add(new X9ECPoint(this.g));
        aSN1EncodableVector.add(new DERInteger(this.n));
        if (!this.h.equals(BigInteger.valueOf(1L))) {
            aSN1EncodableVector.add(new DERInteger(this.h));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

