/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.paddings;

import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] byArray, int n) {
        byte by = (byte)(byArray.length - n);
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n = byArray[byArray.length - 1] & 0xFF;
        if (n > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        int n2 = 1;
        while (n2 <= n) {
            if (byArray[byArray.length - n2] != n) {
                throw new InvalidCipherTextException("pad block corrupted");
            }
            ++n2;
        }
        return n;
    }
}

