/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.generators.DSAKeyPairGenerator;
import cn.com.infosec.crypto.generators.DSAParametersGenerator;
import cn.com.infosec.crypto.params.DSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAValidationParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.signers.DSASigner;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSATest
implements Test {
    SecureRandom random = new SecureRandom(){
        boolean first = true;

        public void nextBytes(byte[] byArray) {
            byte[] byArray2 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
            byte[] byArray3 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
            if (this.first) {
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                this.first = false;
            } else {
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            }
        }
    };
    SecureRandom keyRandom = new SecureRandom(){

        public void nextBytes(byte[] byArray) {
            byte[] byArray2 = Hex.decode("b5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
            int n = 0;
            while (n < byArray.length - byArray2.length) {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            }
            if (n > byArray.length) {
                System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
            } else {
                System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
            }
        }
    };
    BigInteger pValue = new BigInteger("8df2a494492276aa3d25759bb06869cbeac0d83afb8d0cf7cbb8324f0d7882e5d0762fc5b7210eafc2e9adac32ab7aac49693dfbf83724c2ec0736ee31c80291", 16);
    BigInteger qValue = new BigInteger("c773218c737ec8ee993b4f2ded30f48edace915f", 16);

    public String getName() {
        return "DSA";
    }

    public TestResult perform() {
        BigInteger bigInteger = new BigInteger("68076202252361894315274692543577577550894681403");
        BigInteger bigInteger2 = new BigInteger("1089214853334067536215539335472893651470583479365");
        DSAParametersGenerator dSAParametersGenerator = new DSAParametersGenerator();
        dSAParametersGenerator.init(512, 80, this.random);
        DSAParameters dSAParameters = dSAParametersGenerator.generateParameters();
        DSAValidationParameters dSAValidationParameters = dSAParameters.getValidationParameters();
        if (dSAValidationParameters.getCounter() != 105) {
            return new SimpleTestResult(false, this.getName() + ": Counter wrong");
        }
        if (!this.pValue.equals(dSAParameters.getP()) || !this.qValue.equals(dSAParameters.getQ())) {
            return new SimpleTestResult(false, this.getName() + ": p or q wrong");
        }
        DSAKeyPairGenerator dSAKeyPairGenerator = new DSAKeyPairGenerator();
        DSAKeyGenerationParameters dSAKeyGenerationParameters = new DSAKeyGenerationParameters(this.keyRandom, dSAParameters);
        dSAKeyPairGenerator.init(dSAKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dSAKeyPairGenerator.generateKeyPair();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.keyRandom);
        DSASigner dSASigner = new DSASigner();
        dSASigner.init(true, parametersWithRandom);
        byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
        BigInteger[] bigIntegerArray = dSASigner.generateSignature(byArray);
        if (!bigInteger.equals(bigIntegerArray[0])) {
            return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
        dSASigner.init(false, asymmetricCipherKeyPair.getPublic());
        if (dSASigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        return new SimpleTestResult(false, this.getName() + ": verification fails");
    }

    public static void main(String[] stringArray) {
        DSATest dSATest = new DSATest();
        TestResult testResult = dSATest.perform();
        System.out.println(testResult);
    }
}

