/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.digests.RIPEMD320Digest;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class RIPEMD320DigestTest
implements Test {
    static final String[] messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
    static final String[] digests = new String[]{"22d65d5661536cdc75c1fdf5c6de7b41b9f27325ebc61e8557177d705a0ec880151c3a32a00899b8", "ce78850638f92658a5a585097579926dda667a5716562cfcf6fbe77f63542f99b04705d6970dff5d", "de4c01b3054f8930a79d09ae738e92301e5a17085beffdc1b8d116713e74f82fa942d64cdbc4682d", "3a8e28502ed45d422f68844f9dd316e7b98533fa3f2a91d29f84d425c88d6b4eff727df66a7c0197", "cabdb1810b92470a2093aa6bce05952c28348cf43ff60841975166bb40ed234004b8824463e6b009", "d034a7950cf722021ba4b84df769a5de2060e259df4c9bb4a4268c0e935bbc7470a969c9d072a1ac", "ed544940c86d67f250d232c30b7b3e5770e0c60c8cb9a4cafe3b11388af9920e1b99230b843c86a4", "557888af5f6d8ed62ab66945c6d2a0a47ecd5341e915eb8fea1d0524955f825dc717e4a008ab2d42"};
    static final String million_a_digest = "bdee37f4371e20646b8b0d862dda16292ae36f40965e8c8509e63d1dbddecc503e2b63eb9245bb66";

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "RIPEMD320";
    }

    public TestResult perform() {
        byte[] byArray;
        RIPEMD320Digest rIPEMD320Digest = new RIPEMD320Digest();
        byte[] byArray2 = new byte[rIPEMD320Digest.getDigestSize()];
        int n = 0;
        while (n < messages.length) {
            byArray = messages[n].getBytes();
            rIPEMD320Digest.update(byArray, 0, byArray.length);
            rIPEMD320Digest.doFinal(byArray2, 0);
            if (!RIPEMD320DigestTest.arraysEqual(byArray2, Hex.decode(digests[n]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed");
            }
            ++n;
        }
        byArray = messages[messages.length - 1].getBytes();
        rIPEMD320Digest.update(byArray, 0, byArray.length / 2);
        RIPEMD320Digest rIPEMD320Digest2 = new RIPEMD320Digest(rIPEMD320Digest);
        rIPEMD320Digest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD320Digest.doFinal(byArray2, 0);
        if (!RIPEMD320DigestTest.arraysEqual(byArray2, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD320 failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(byArray2)));
        }
        rIPEMD320Digest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD320Digest2.doFinal(byArray2, 0);
        if (!RIPEMD320DigestTest.arraysEqual(byArray2, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD320 failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(byArray2)));
        }
        int n2 = 0;
        while (n2 < 1000000) {
            rIPEMD320Digest.update((byte)97);
            ++n2;
        }
        rIPEMD320Digest.doFinal(byArray2, 0);
        if (!RIPEMD320DigestTest.arraysEqual(byArray2, Hex.decode(million_a_digest))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        RIPEMD320DigestTest rIPEMD320DigestTest = new RIPEMD320DigestTest();
        TestResult testResult = rIPEMD320DigestTest.perform();
        System.out.println(testResult);
    }
}

