/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class SHA1DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static String testVec2 = "61";
    private static String resVec2 = "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8";
    private static String testVec3 = "616263";
    private static String resVec3 = "a9993e364706816aba3e25717850c26c9cd0d89d";
    private static String testVec4 = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
    private static String resVec4 = "32d10c7b8cf96570ca04ce37f2a19d84240d3a89";

    public String getName() {
        return "SHA1";
    }

    public TestResult perform() {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode(byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode(testVec2);
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec3);
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec4);
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec4);
        sHA1Digest.update(byArray2, 0, byArray2.length / 2);
        SHA1Digest sHA1Digest2 = new SHA1Digest(sHA1Digest);
        sHA1Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA1Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA1 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        sHA1Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA1Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA1 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        SHA1DigestTest sHA1DigestTest = new SHA1DigestTest();
        TestResult testResult = sHA1DigestTest.perform();
        System.out.println(testResult);
    }
}

