/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.StreamCipher;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class StreamCipherVectorTest
implements Test {
    int id;
    StreamCipher cipher;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public StreamCipherVectorTest(int n, StreamCipher streamCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.cipher = streamCipher;
        this.param = cipherParameters;
        this.input = Hex.decode(string);
        this.output = Hex.decode(string2);
    }

    public String getName() {
        return this.cipher.getAlgorithmName() + " Vector Test " + this.id;
    }

    public TestResult perform() {
        this.cipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        this.cipher.processBytes(this.input, 0, this.input.length, byArray, 0);
        if (!this.isEqualArray(byArray, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(byArray)));
        }
        this.cipher.init(false, this.param);
        this.cipher.processBytes(this.output, 0, this.output.length, byArray, 0);
        if (!this.isEqualArray(this.input, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal");
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }

    private boolean isEqualArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

