/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.util;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.oiw.ElGamalParameter;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.DHParameter;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.pkcs.RSAPrivateKeyStructure;
import cn.com.infosec.asn1.sec.ECPrivateKeyStructure;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.DSAParameter;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.IOException;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure rSAPrivateKeyStructure = new RSAPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(rSAPrivateKeyStructure.getModulus(), rSAPrivateKeyStructure.getPublicExponent(), rSAPrivateKeyStructure.getPrivateExponent(), rSAPrivateKeyStructure.getPrime1(), rSAPrivateKeyStructure.getPrime2(), rSAPrivateKeyStructure.getExponent1(), rSAPrivateKeyStructure.getExponent2(), rSAPrivateKeyStructure.getCoefficient());
        }
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter dHParameter = new DHParameter((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            return new DHPrivateKeyParameters(dERInteger.getValue(), new DHParameters(dHParameter.getP(), dHParameter.getG()));
        }
        if (algorithmIdentifier.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(dERInteger.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DSAParameter dSAParameter = new DSAParameter((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            return new DSAPrivateKeyParameters(dERInteger.getValue(), new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG()));
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)privateKeyInfo.getAlgorithmId().getParameters());
            ECDomainParameters eCDomainParameters = null;
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                X9ECParameters x9ECParameters = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            }
            aSN1Encodable = new ECPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(((ECPrivateKeyStructure)aSN1Encodable).getKey(), eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

