/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.DERTags;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.pkcs.SignerInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.CertificateList;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.X509CRLObject;
import cn.com.infosec.jce.provider.X509CertificateObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private byte[] contentData;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedData(byte[] byArray) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this(byArray, "INFOSEC");
    }

    public PKCS7SignedData(byte[] byArray, String string) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        ASN1Encodable aSN1Encodable;
        DERObject dERObject;
        Object object;
        Object object2;
        DERObject dERObject2;
        DERInputStream dERInputStream = new DERInputStream(new ByteArrayInputStream(byArray));
        try {
            dERObject2 = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(dERObject2 instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo contentInfo = ContentInfo.getInstance(dERObject2);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        this.certs = new ArrayList();
        if (signedData.getCertificates() != null) {
            object2 = ASN1Set.getInstance(signedData.getCertificates()).getObjects();
            while (object2.hasMoreElements()) {
                this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(object2.nextElement())));
            }
        }
        this.crls = new ArrayList();
        if (signedData.getCRLs() != null) {
            object2 = ASN1Set.getInstance(signedData.getCRLs()).getObjects();
            while (object2.hasMoreElements()) {
                this.crls.add(new X509CRLObject(CertificateList.getInstance(object2.nextElement())));
            }
        }
        this.version = signedData.getVersion().getValue().intValue();
        object2 = signedData.getContentInfo();
        DEREncodable dEREncodable = ((ContentInfo)object2).getContent();
        if (dEREncodable != null) {
            object = (ASN1OctetString)dEREncodable;
            this.contentData = ((ASN1OctetString)object).getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        object = signedData.getDigestAlgorithms().getObjects();
        while (object.hasMoreElements()) {
            dERObject = (DERConstructedSequence)object.nextElement();
            aSN1Encodable = (DERObjectIdentifier)((ASN1Sequence)dERObject).getObjectAt(0);
            this.digestalgos.add(((DERObjectIdentifier)aSN1Encodable).getId());
        }
        dERObject = (DERConstructedSet)signedData.getSignerInfos();
        if (((DERConstructedSet)dERObject).getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        aSN1Encodable = SignerInfo.getInstance(((ASN1Set)dERObject).getObjectAt(0));
        this.signerversion = ((SignerInfo)aSN1Encodable).getVersion().getValue().intValue();
        IssuerAndSerialNumber issuerAndSerialNumber = ((SignerInfo)aSN1Encodable).getIssuerAndSerialNumber();
        BigInteger bigInteger = issuerAndSerialNumber.getCertificateSerialNumber().getValue();
        X509Principal x509Principal = new X509Principal(issuerAndSerialNumber.getName());
        Iterator iterator = this.certs.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            if (!bigInteger.equals(x509Certificate.getSerialNumber()) || !x509Principal.equals(x509Certificate.getIssuerDN())) continue;
            this.signCert = x509Certificate;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + bigInteger.toString(16));
        }
        this.digestAlgorithm = ((SignerInfo)aSN1Encodable).getDigestAlgorithm().getObjectId().getId();
        this.digest = ((SignerInfo)aSN1Encodable).getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = ((SignerInfo)aSN1Encodable).getDigestEncryptionAlgorithm().getObjectId().getId();
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), string);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, String string) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privateKey, certificateArray, string, "INFOSEC");
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, String string, String string2) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privateKey, certificateArray, null, string, string2);
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, String string, String string2) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.privKey = privateKey;
        if (string.equals("MD5")) {
            this.digestAlgorithm = "1.2.840.113549.2.5";
        } else if (string.equals("MD2")) {
            this.digestAlgorithm = "1.2.840.113549.2.2";
        } else if (string.equals("SHA")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else if (string.equals("SHA1")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + string);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certificateArray[0];
        int n = 0;
        while (n < certificateArray.length) {
            this.certs.add(certificateArray[n]);
            ++n;
        }
        if (cRLArray != null) {
            int n2 = 0;
            while (n2 < cRLArray.length) {
                this.crls.add(cRLArray[n2]);
                ++n2;
            }
        }
        this.digestEncryptionAlgorithm = privateKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), string2);
        this.sig.initSign(privateKey);
    }

    public String getDigestAlgorithm() {
        String string = this.digestAlgorithm;
        String string2 = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            string = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            string = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            string = "SHA1";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            string2 = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            string2 = "DSA";
        }
        return string + "with" + string2;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public void update(byte by) throws SignatureException {
        this.sig.update(by);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sig.update(byArray, n, n2);
    }

    public boolean verify() throws SignatureException {
        return this.sig.verify(this.digest);
    }

    private DERObject getIssuer(byte[] byArray) {
        try {
            DERInputStream dERInputStream = new DERInputStream(new ByteArrayInputStream(byArray));
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERInputStream.readObject();
            return (DERObject)dERConstructedSequence.getObjectAt(dERConstructedSequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new Error("IOException reading from ByteArray: " + iOException);
        }
    }

    public byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] byArray) {
        try {
            Closeable closeable;
            Object object;
            DERConstructedSet dERConstructedSet;
            DERTags dERTags;
            Object object2;
            DERObject dERObject;
            ASN1Encodable aSN1Encodable;
            if (null == this.digest) {
                this.digest = this.sig.sign();
            }
            DERConstructedSet dERConstructedSet2 = new DERConstructedSet();
            Iterator iterator = this.digestalgos.iterator();
            while (iterator.hasNext()) {
                aSN1Encodable = new AlgorithmIdentifier(new DERObjectIdentifier((String)iterator.next()), null);
                dERConstructedSet2.addObject(aSN1Encodable);
            }
            aSN1Encodable = new DERConstructedSequence();
            ((DERConstructedSequence)aSN1Encodable).addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (byArray != null) {
                dERObject = new DEROctetString(byArray);
                object2 = new DERTaggedObject(0, dERObject);
                ((DERConstructedSequence)aSN1Encodable).addObject((DEREncodable)object2);
            }
            dERObject = new DERConstructedSet();
            object2 = this.certs.iterator();
            while (object2.hasNext()) {
                dERTags = new DERInputStream(new ByteArrayInputStream(((X509Certificate)object2.next()).getEncoded()));
                ((DERConstructedSet)dERObject).addObject(((DERInputStream)dERTags).readObject());
            }
            dERTags = new DERConstructedSequence();
            ((DERConstructedSequence)dERTags).addObject(new DERInteger(this.signerversion));
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(new X509Name((DERConstructedSequence)this.getIssuer(this.signCert.getTBSCertificate())), new DERInteger(this.signCert.getSerialNumber()));
            ((DERConstructedSequence)dERTags).addObject(issuerAndSerialNumber);
            ((DERConstructedSequence)dERTags).addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            ((DERConstructedSequence)dERTags).addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            ((DERConstructedSequence)dERTags).addObject(new DEROctetString(this.digest));
            DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
            dERConstructedSequence.addObject(new DERInteger(this.version));
            dERConstructedSequence.addObject(dERConstructedSet2);
            dERConstructedSequence.addObject(aSN1Encodable);
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0, dERObject));
            if (this.crls.size() > 0) {
                dERConstructedSet = new DERConstructedSet();
                object = this.crls.iterator();
                while (object.hasNext()) {
                    closeable = new DERInputStream(new ByteArrayInputStream(((X509CRL)object.next()).getEncoded()));
                    dERConstructedSet.addObject(((DERInputStream)closeable).readObject());
                }
                dERConstructedSequence.addObject(new DERTaggedObject(false, 1, dERConstructedSet));
            }
            dERConstructedSet = new DERConstructedSet();
            dERConstructedSet.addObject((DEREncodable)((Object)dERTags));
            dERConstructedSequence.addObject(dERConstructedSet);
            object = new DERConstructedSequence();
            ((DERConstructedSequence)object).addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            ((DERConstructedSequence)object).addObject(new DERTaggedObject(0, dERConstructedSequence));
            closeable = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)closeable);
            dEROutputStream.writeObject(object);
            dEROutputStream.close();
            return ((ByteArrayOutputStream)closeable).toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }
}

