/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.x509.TBSCertList;
import cn.com.infosec.asn1.x509.TBSCertificateStructure;
import cn.com.infosec.jce.X509Principal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PrincipalUtil {
    public static X509Principal getIssuerX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = new TBSCertificateStructure((ASN1Sequence)aSN1InputStream.readObject());
            return new X509Principal(tBSCertificateStructure.getIssuer());
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getSubjectX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = new TBSCertificateStructure((ASN1Sequence)aSN1InputStream.readObject());
            return new X509Principal(tBSCertificateStructure.getSubject());
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getIssuerX509Principal(X509CRL x509CRL) throws CRLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509CRL.getTBSCertList());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            TBSCertList tBSCertList = new TBSCertList((ASN1Sequence)aSN1InputStream.readObject());
            return new X509Principal(tBSCertList.getIssuer());
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }
}

