/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        CertPathValidator certPathValidator;
        CertificateFactory certificateFactory;
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        CertPath certPath = null;
        GeneralSecurityException generalSecurityException = null;
        CertSelector certSelector = pKIXBuilderParameters.getTargetCertConstraints();
        if (certSelector == null) {
            throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
        }
        Collection collection = this.findCertificates(certSelector, pKIXBuilderParameters.getCertStores());
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("no certificate found matching targetCertContraints");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "INFOSEC");
            certPathValidator = CertPathValidator.getInstance("PKIX", "INFOSEC");
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("exception creating support classes: " + exception);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = (X509Certificate)iterator.next();
            arrayList.clear();
            while (object != null) {
                Object object2;
                arrayList.add((X509Certificate)object);
                if (this.findTrustAnchor((X509Certificate)object, pKIXBuilderParameters.getTrustAnchors()) != null) {
                    try {
                        certPath = certificateFactory.generateCertPath(arrayList);
                        object2 = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
                        return new PKIXCertPathBuilderResult(certPath, ((PKIXCertPathValidatorResult)object2).getTrustAnchor(), ((PKIXCertPathValidatorResult)object2).getPolicyTree(), ((PKIXCertPathValidatorResult)object2).getPublicKey());
                    }
                    catch (CertificateException certificateException) {
                        generalSecurityException = certificateException;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        generalSecurityException = certPathValidatorException;
                    }
                    object = null;
                    continue;
                }
                try {
                    object2 = this.findIssuer((X509Certificate)object, pKIXBuilderParameters.getCertStores());
                    if (((Certificate)object2).equals(object)) {
                        object = null;
                        continue;
                    }
                    object = object2;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    generalSecurityException = certPathValidatorException;
                    object = null;
                }
            }
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certificate chain, but could not be validated", generalSecurityException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, Set var2_2) throws CertPathBuilderException {
        var3_3 = var2_2.iterator();
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = new X509CertSelector();
        try {
            var7_7.setSubject(var1_1.getIssuerX500Principal().getEncoded());
            if (true) ** GOTO lbl39
        }
        catch (IOException var8_8) {
            throw new CertPathBuilderException("can't get trust anchor principal", null);
        }
        do {
            block15: {
                if ((var4_4 = (TrustAnchor)var3_3.next()).getTrustedCert() != null) {
                    if (var7_7.match(var4_4.getTrustedCert())) {
                        var5_5 = var4_4.getTrustedCert().getPublicKey();
                    } else {
                        var4_4 = null;
                    }
                } else if (var4_4.getCAName() != null && var4_4.getCAPublicKey() != null) {
                    try {
                        var8_9 = var1_1.getIssuerX500Principal();
                        var9_12 = new X500Principal(var4_4.getCAName());
                        if (var8_9.equals(var9_12)) {
                            var5_5 = var4_4.getCAPublicKey();
                            break block15;
                        }
                        var4_4 = null;
                    }
                    catch (IllegalArgumentException var8_10) {
                        var4_4 = null;
                    }
                } else {
                    var4_4 = null;
                }
            }
            if (var5_5 == null) continue;
            try {
                var1_1.verify(var5_5);
            }
            catch (Exception var8_11) {
                var6_6 = var8_11;
                var4_4 = null;
            }
lbl39:
            // 4 sources

        } while (var3_3.hasNext() && var4_4 == null);
        if (var4_4 == null && var6_6 != null) {
            throw new CertPathBuilderException("TrustAnchor found put certificate validation failed", var6_6);
        }
        return var4_4;
    }

    private final Collection findCertificates(CertSelector certSelector, List list) {
        HashSet<? extends Certificate> hashSet = new HashSet<Certificate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCertificates(certSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    private final X509Certificate findIssuer(X509Certificate x509Certificate, List list) throws CertPathValidatorException {
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        Iterator iterator = this.findCertificates(x509CertSelector, list).iterator();
        X509Certificate x509Certificate2 = null;
        while (iterator.hasNext() && x509Certificate2 == null) {
            x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception2) {
                exception = exception2;
                x509Certificate2 = null;
            }
        }
        if (x509Certificate2 == null && exception == null) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        if (x509Certificate2 == null && exception != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)exception, null, -1);
        }
        return x509Certificate2;
    }
}

