/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERBoolean;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.misc.MiscObjectIdentifiers;
import cn.com.infosec.asn1.misc.NetscapeCertType;
import cn.com.infosec.asn1.misc.NetscapeRevocationURL;
import cn.com.infosec.asn1.misc.VerisignCzagExtension;
import cn.com.infosec.asn1.util.ASN1Dump;
import cn.com.infosec.asn1.x509.BasicConstraints;
import cn.com.infosec.asn1.x509.KeyUsage;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.asn1.x509.X509Extension;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.interfaces.PKCS12BagAttributeCarrier;
import cn.com.infosec.jce.provider.JDKKeyFactory;
import cn.com.infosec.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509CertificateObject
extends X509Certificate
implements PKCS12BagAttributeCarrier {
    private X509CertificateStructure c;
    private Hashtable pkcs12Attributes = new Hashtable();
    private Vector pkcs12Ordering = new Vector();

    public X509CertificateObject(X509CertificateStructure x509CertificateStructure) {
        this.c = x509CertificateStructure;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("certificate expired on " + this.c.getEndDate().getTime());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.c.getStartDate().getTime());
        }
    }

    public int getVersion() {
        return this.c.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.c.getSerialNumber().getValue();
    }

    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Principal getSubjectDN() {
        return new X509Principal(this.c.getSubject());
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getSubject());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getNotBefore() {
        return this.c.getStartDate().getDate();
    }

    public Date getNotAfter() {
        return this.c.getEndDate().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c.getTBSCertificate());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    public String getSigAlgName() {
        Provider provider = Security.getProvider("INFOSEC");
        String string = provider.getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
        if (string != null) {
            return string;
        }
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n != providerArray.length) {
            string = providerArray[n].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string != null) {
                return string;
            }
            ++n;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSigAlgParams() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.c.getSignatureAlgorithm().getParameters() != null) {
            try {
                DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                dEROutputStream.writeObject(this.c.getSignatureAlgorithm().getParameters());
            }
            catch (Exception exception) {
                throw new RuntimeException("exception getting sig parameters " + exception);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        DERBitString dERBitString = this.c.getTBSCertificate().getIssuerUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            int n = 0;
            while (n != blArray.length) {
                blArray[n] = (byArray[n / 8] & 128 >>> n % 8) != 0;
                ++n;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        DERBitString dERBitString = this.c.getTBSCertificate().getSubjectUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            int n = 0;
            while (n != blArray.length) {
                blArray[n] = (byArray[n / 8] & 128 >>> n % 8) != 0;
                ++n;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        byte[] byArray = this.getExtensionBytes("2.5.29.15");
        int n = 0;
        if (byArray != null) {
            Object object;
            try {
                object = new ASN1InputStream(new ByteArrayInputStream(byArray));
                DERBitString dERBitString = (DERBitString)((ASN1InputStream)object).readObject();
                byArray = dERBitString.getBytes();
                n = byArray.length * 8 - dERBitString.getPadBits();
            }
            catch (Exception exception) {
                throw new RuntimeException("error processing key usage extension");
            }
            object = new boolean[n < 9 ? 9 : n];
            int n2 = 0;
            while (n2 != n) {
                object[n2] = (byArray[n2 / 8] & 128 >>> n2 % 8) != 0;
                ++n2;
            }
            return object;
        }
        return null;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.getExtensionBytes("2.5.29.37");
        boolean bl = false;
        if (byArray != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n != aSN1Sequence.size()) {
                    arrayList.add(((DERObjectIdentifier)aSN1Sequence.getObjectAt(n)).getId());
                    ++n;
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        byte[] byArray = this.getExtensionBytes("2.5.29.19");
        if (byArray != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                if (aSN1Sequence.size() == 2) {
                    if (((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                        return ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue().intValue();
                    }
                    return -1;
                }
                if (aSN1Sequence.size() == 1) {
                    if (aSN1Sequence.getObjectAt(0) instanceof DERBoolean) {
                        if (((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                            return Integer.MAX_VALUE;
                        }
                        return -1;
                    }
                    return -1;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("error processing key usage extension");
            }
        }
        return -1;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                    if (!x509Extension.isCritical()) continue;
                    hashSet.add(dERObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            return x509Extension.getValue().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                dEROutputStream.writeObject(x509Extension.getValue());
                return byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                    if (x509Extension.isCritical()) continue;
                    hashSet.add(dERObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        X509Extensions x509Extensions;
        if (this.getVersion() == 3 && (x509Extensions = this.c.getTBSCertificate().getExtensions()) != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                X509Extension x509Extension;
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                if (dERObjectIdentifier.getId().equals("2.5.29.15") || dERObjectIdentifier.getId().equals("2.5.29.19") || !(x509Extension = x509Extensions.getExtension(dERObjectIdentifier)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    public PublicKey getPublicKey() {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(this.c.getSubjectPublicKeyInfo());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public void setBagAttribute(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.pkcs12Attributes.put(dERObjectIdentifier, dEREncodable);
        this.pkcs12Ordering.addElement(dERObjectIdentifier);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier dERObjectIdentifier) {
        return (DEREncodable)this.pkcs12Attributes.get(dERObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.pkcs12Ordering.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("  [0]         Version: " + this.getVersion() + string);
        stringBuffer.append("         SerialNumber: " + this.getSerialNumber() + string);
        stringBuffer.append("             IssuerDN: " + this.getIssuerDN() + string);
        stringBuffer.append("           Start Date: " + this.getNotBefore() + string);
        stringBuffer.append("           Final Date: " + this.getNotAfter() + string);
        stringBuffer.append("            SubjectDN: " + this.getSubjectDN() + string);
        stringBuffer.append("           Public Key: " + this.getPublicKey() + string);
        stringBuffer.append("  Signature Algorithm: " + this.getSigAlgName() + string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: " + new String(Hex.encode(byArray, 0, 20)) + string);
        int n = 20;
        while (n < byArray.length) {
            if (n < byArray.length - 20) {
                stringBuffer.append("                       " + new String(Hex.encode(byArray, n, 20)) + string);
            } else {
                stringBuffer.append("                       " + new String(Hex.encode(byArray, n, byArray.length - n)) + string);
            }
            n += 20;
        }
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    byte[] byArray2 = x509Extension.getValue().getOctets();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                    stringBuffer.append("                       critical(" + x509Extension.isCritical() + ") ");
                    try {
                        if (dERObjectIdentifier.equals(X509Extensions.BasicConstraints)) {
                            stringBuffer.append(new BasicConstraints((ASN1Sequence)aSN1InputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(X509Extensions.KeyUsage)) {
                            stringBuffer.append(new KeyUsage((DERBitString)aSN1InputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            stringBuffer.append(new NetscapeCertType((DERBitString)aSN1InputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            stringBuffer.append(new NetscapeRevocationURL((DERIA5String)aSN1InputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            stringBuffer.append(new VerisignCzagExtension((DERIA5String)aSN1InputStream.readObject()) + string);
                            continue;
                        }
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = " + ASN1Dump.dumpAsString(aSN1InputStream.readObject()) + string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = *****" + string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = null;
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        try {
            signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId(), "INFOSEC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId());
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId(), string);
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }
}

