/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.security.MessageDigest;
import java.security.Security;

public class DigestTest
implements Test {
    static final String provider = "INFOSEC";
    private static String[][] abcVectors = new String[][]{{"MD2", "da853b0d3f88d99b30283a69e6ded6bb"}, {"MD4", "a448017aaf21d8525fc10ae87aa6729d"}, {"MD5", "900150983cd24fb0d6963f7d28e17f72"}, {"SHA-1", "a9993e364706816aba3e25717850c26c9cd0d89d"}, {"SHA-224", "23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7"}, {"SHA-256", "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad"}, {"SHA-384", "cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7"}, {"SHA-512", "ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f"}, {"RIPEMD128", "c14a12199c66e4ba84636b0f69144c77"}, {"RIPEMD256", "afbd6e228b9d8cbbcef5ca2d03e6dba10ac0bc7dcbe4680e1e42d2e975459b65"}, {"RIPEMD320", "de4c01b3054f8930a79d09ae738e92301e5a17085beffdc1b8d116713e74f82fa942d64cdbc4682d"}, {"Tiger", "2AAB1484E8C158F2BFB8C5FF41B57A525129131C957B5F93"}};

    public String getName() {
        return "Digest";
    }

    TestResult test(String string) {
        byte[] byArray = "hello world".getBytes();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, provider);
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest.digest(byArray);
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 1 not equal");
            }
            int n = 0;
            while (n < byArray.length) {
                messageDigest.update(byArray[n]);
                ++n;
            }
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 2 not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 3 not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            MessageDigest messageDigest2 = (MessageDigest)messageDigest.clone();
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 4(a) not equal");
            }
            messageDigest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest2.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 4(b) not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.reset();
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 5 not equal");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed exception - " + exception.toString());
        }
    }

    TestResult abcTest(String string, String string2) {
        try {
            byte[] byArray = new byte[]{97, 98, 99};
            MessageDigest messageDigest = MessageDigest.getInstance(string, provider);
            byte[] byArray2 = messageDigest.digest(byArray);
            if (!MessageDigest.isEqual(byArray2, Hex.decode(string2))) {
                return new SimpleTestResult(false, "abc result not equal for " + string);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed abcTest exception - " + exception.toString());
        }
    }

    public TestResult perform() {
        boolean bl = false;
        TestResult testResult = this.test("SHA-1");
        if (!testResult.isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-224")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-256")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-384")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-512")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD2")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD4")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD5")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD128")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD160")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD256")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD320")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("Tiger")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        int n = 0;
        while (n != abcVectors.length) {
            testResult = this.abcTest(abcVectors[n][0], abcVectors[n][1]);
            if (!testResult.isSuccessful()) {
                System.out.println(testResult);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return new SimpleTestResult(false, this.getName() + ": Failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        DigestTest digestTest = new DigestTest();
        TestResult testResult = digestTest.perform();
        System.out.println(testResult.toString());
    }
}

