/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.spec.ECParameterSpec;
import cn.com.infosec.jce.spec.IEKeySpec;
import cn.com.infosec.jce.spec.IESParameterSpec;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;

public class ECIESTest
implements Test {
    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "INFOSEC");
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
            TestResult testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "INFOSEC");
            keyPairGenerator.initialize(192, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "INFOSEC");
            keyPairGenerator.initialize(239, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "INFOSEC");
            keyPairGenerator.initialize(256, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.performDefTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult performTest(KeyPairGenerator keyPairGenerator) {
        try {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            PublicKey publicKey2 = keyPair2.getPublic();
            PrivateKey privateKey2 = keyPair2.getPrivate();
            Cipher cipher = Cipher.getInstance("ECIES", "INFOSEC");
            Cipher cipher2 = Cipher.getInstance("ECIES", "INFOSEC");
            IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
            IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
            IESParameterSpec iESParameterSpec = new IESParameterSpec(byArray, byArray2, 128);
            cipher.init(1, (Key)iEKeySpec, iESParameterSpec);
            cipher2.init(2, (Key)iEKeySpec2, iESParameterSpec);
            byte[] byArray3 = Hex.decode("1234567890abcdef");
            byte[] byArray4 = cipher.doFinal(byArray3, 0, byArray3.length);
            byte[] byArray5 = cipher2.doFinal(byArray4, 0, byArray4.length);
            if (!this.sameAs(byArray5, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult performDefTest(KeyPairGenerator keyPairGenerator) {
        try {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            PublicKey publicKey2 = keyPair2.getPublic();
            PrivateKey privateKey2 = keyPair2.getPrivate();
            Cipher cipher = Cipher.getInstance("ECIES", "INFOSEC");
            Cipher cipher2 = Cipher.getInstance("ECIES", "INFOSEC");
            IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
            IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
            cipher.init(1, iEKeySpec);
            AlgorithmParameters algorithmParameters = cipher.getParameters();
            cipher2.init(2, (Key)iEKeySpec2, algorithmParameters);
            byte[] byArray = Hex.decode("1234567890abcdef");
            byte[] byArray2 = cipher.doFinal(byArray, 0, byArray.length);
            byte[] byArray3 = cipher2.doFinal(byArray2, 0, byArray2.length);
            if (!this.sameAs(byArray3, byArray)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        ECIESTest eCIESTest = new ECIESTest();
        TestResult testResult = eCIESTest.perform();
        System.out.println(testResult);
    }
}

