/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedPrivateKeyInfoTest
implements Test {
    String alg = "1.2.840.113549.1.12.1.3";

    public TestResult perform() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "INFOSEC");
            keyPairGenerator.initialize(512, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            int n = 100;
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.alg, "INFOSEC");
            algorithmParameters.init(pBEParameterSpec);
            char[] cArray = new char[]{'h', 'e', 'l', 'l', 'o'};
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.alg, "INFOSEC");
            Cipher cipher = Cipher.getInstance(this.alg, "INFOSEC");
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), algorithmParameters);
            byte[] byArray2 = cipher.wrap(privateKey);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmParameters, byArray2);
            char[] cArray2 = new char[]{'h', 'e', 'l', 'l', 'o'};
            pBEKeySpec = new PBEKeySpec(cArray2);
            cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName(), "INFOSEC");
            cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), encryptedPrivateKeyInfo.getAlgParameters());
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
            if (!MessageDigest.isEqual(privateKey.getEncoded(), pKCS8EncodedKeySpec.getEncoded())) {
                return new SimpleTestResult(false, "Private key does not match");
            }
            pBEKeySpec = new PBEKeySpec(cArray);
            secretKeyFactory = SecretKeyFactory.getInstance(this.alg, "INFOSEC");
            cipher = Cipher.getInstance(this.alg, "INFOSEC");
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), algorithmParameters);
            byArray2 = cipher.wrap(privateKey);
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(cipher.getParameters(), byArray2);
            pBEKeySpec = new PBEKeySpec(cArray2);
            cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName(), "INFOSEC");
            cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), encryptedPrivateKeyInfo.getAlgParameters());
            pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
            if (!MessageDigest.isEqual(privateKey.getEncoded(), pKCS8EncodedKeySpec.getEncoded())) {
                return new SimpleTestResult(false, "Private key does not match");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "EncryptedPrivateKeyInfoTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        EncryptedPrivateKeyInfoTest encryptedPrivateKeyInfoTest = new EncryptedPrivateKeyInfoTest();
        TestResult testResult = encryptedPrivateKeyInfoTest.perform();
        System.out.println(testResult.toString());
    }
}

