/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FIPSDESTest
implements Test {
    static String[] fips1Tests = new String[]{"DES/ECB/NoPadding", "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53", "DES/CBC/NoPadding", "e5c7cdde872bf27c43e934008c389c0f683788499a7c05f6", "DES/CFB/NoPadding", "f3096249c7f46e51a69e839b1a92f78403467133898ea622"};
    static String[] fips2Tests = new String[]{"DES/CFB8/NoPadding", "f31fda07011462ee187f", "DES/OFB8/NoPadding", "f34a2850c9c64985d684"};
    static byte[] input1 = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
    static byte[] input2 = Hex.decode("4e6f7720697320746865");

    public String getName() {
        return "FIPSDESTest";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult test(String string, byte[] byArray, byte[] byArray2) {
        Cipher cipher;
        Cipher cipher2;
        SecretKeySpec secretKeySpec;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(Hex.decode("1234567890abcdef"));
        try {
            secretKeySpec = new SecretKeySpec(Hex.decode("0123456789abcdef"), "DES");
            cipher2 = Cipher.getInstance(string, "INFOSEC");
            cipher = Cipher.getInstance(string, "INFOSEC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString());
        }
        try {
            cipher2.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            int n = 0;
            while (n != byArray.length / 2) {
                cipherOutputStream.write(byArray[n]);
                ++n;
            }
            cipherOutputStream.write(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + iOException.toString());
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray3, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray3 = new byte[byArray.length];
            int n = 0;
            while (n != byArray.length / 2) {
                byArray3[n] = (byte)dataInputStream.read();
                ++n;
            }
            dataInputStream.readFully(byArray3, byArray.length / 2, byArray3.length - byArray.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + exception.toString());
        }
        if (!this.equalArray(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed decryption - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
        return new SimpleTestResult(true, this.getName() + ": " + string + " Okay");
    }

    public TestResult perform() {
        int n = 0;
        while (n != fips1Tests.length) {
            TestResult testResult = this.test(fips1Tests[n], input1, Hex.decode(fips1Tests[n + 1]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n += 2;
        }
        int n2 = 0;
        while (n2 != fips2Tests.length) {
            TestResult testResult = this.test(fips2Tests[n2], input2, Hex.decode(fips2Tests[n2 + 1]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n2 += 2;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) throws KeyException, InvalidAlgorithmParameterException {
        Security.addProvider(new InfosecProvider());
        FIPSDESTest fIPSDESTest = new FIPSDESTest();
        TestResult testResult = fIPSDESTest.perform();
        System.out.println(testResult.toString());
    }
}

