/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.ECNamedCurveTable;
import cn.com.infosec.jce.interfaces.ECPrivateKey;
import cn.com.infosec.jce.interfaces.ECPublicKey;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.spec.ECNamedCurveParameterSpec;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;

public class NamedCurveTest
implements Test {
    private String name;

    NamedCurveTest() {
        this("prime192v1");
    }

    NamedCurveTest(String string) {
        this.name = string;
    }

    public TestResult perform() {
        try {
            X509EncodedKeySpec x509EncodedKeySpec;
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec(this.name);
            if (eCNamedCurveParameterSpec == null) {
                return new SimpleTestResult(false, this.getName() + " no curve for " + this.name + " found.");
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "INFOSEC");
            keyPairGenerator.initialize(eCNamedCurveParameterSpec, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDHC", "INFOSEC");
            keyAgreement.init(keyPair.getPrivate());
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            KeyAgreement keyAgreement2 = KeyAgreement.getInstance("ECDHC", "INFOSEC");
            keyAgreement2.init(keyPair2.getPrivate());
            keyAgreement.doPhase(keyPair2.getPublic(), true);
            keyAgreement2.doPhase(keyPair.getPublic(), true);
            BigInteger bigInteger = new BigInteger(keyAgreement.generateSecret());
            BigInteger bigInteger2 = new BigInteger(keyAgreement2.generateSecret());
            if (!bigInteger.equals(bigInteger2)) {
                return new SimpleTestResult(false, this.getName() + " 2-way test failed");
            }
            byte[] byArray = keyPair.getPublic().getEncoded();
            KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "INFOSEC");
            ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray));
            if (!eCPublicKey.getQ().equals(((ECPublicKey)keyPair.getPublic()).getQ())) {
                return new SimpleTestResult(false, this.getName() + ": public key encoding (Q test) failed");
            }
            if (!(eCPublicKey.getParameters() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, this.getName() + ": public key encoding not named curve");
            }
            byte[] byArray2 = keyPair.getPrivate().getEncoded();
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            ECPrivateKey eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            if (!eCPrivateKey.getD().equals(((ECPrivateKey)keyPair.getPrivate()).getD())) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding (D test) failed");
            }
            if (!(eCPrivateKey.getParameters() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding not named curve");
            }
            if (!((ECNamedCurveParameterSpec)eCPrivateKey.getParameters()).getName().equals(this.name)) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding wrong named curve");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "NamedCurve";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        NamedCurveTest namedCurveTest = stringArray.length == 0 ? new NamedCurveTest() : new NamedCurveTest(stringArray[0]);
        TestResult testResult = namedCurveTest.perform();
        System.out.println(testResult.toString());
    }
}

