/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.ocsp.CertID;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.jce.PrincipalUtil;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class CertificateID {
    public static String HASH_SHA1 = "1.3.14.3.2.26";
    private CertID id;

    public CertificateID(CertID certID) {
        this.id = certID;
    }

    public CertificateID(String string, X509Certificate x509Certificate, BigInteger bigInteger, String string2) throws OCSPException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, string2);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), new DERNull());
            X509Principal x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
            messageDigest.update(x509Principal.getEncoded());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            PublicKey publicKey = x509Certificate.getPublicKey();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(subjectPublicKeyInfo.getPublicKey());
            messageDigest.update(byteArrayOutputStream.toByteArray());
            DEROctetString dEROctetString2 = new DEROctetString(messageDigest.digest());
            DERInteger dERInteger = new DERInteger(bigInteger);
            this.id = new CertID(algorithmIdentifier, dEROctetString, dEROctetString2, dERInteger);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public CertificateID(String string, X509Certificate x509Certificate, BigInteger bigInteger) throws OCSPException {
        this(string, x509Certificate, bigInteger, "INFOSEC");
    }

    public String getHashAlgOID() {
        return this.id.getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertificateID)) {
            return false;
        }
        CertificateID certificateID = (CertificateID)object;
        return this.id.getDERObject().equals(certificateID.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }
}

