/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.openssl;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.x509.DSAParameter;
import cn.com.infosec.jce.PKCS10CertificationRequest;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.x509.X509AttributeCertificate;
import cn.com.infosec.x509.X509V2AttributeCertificate;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class PEMWriter
extends BufferedWriter {
    public PEMWriter(Writer writer) {
        super(writer);
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        char[] cArray = new char[64];
        byArray = Base64.encode(byArray);
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 != cArray.length) {
                if (n + n2 >= byArray.length) break;
                cArray[n2] = (char)byArray[n + n2];
                ++n2;
            }
            this.write(cArray, 0, n2);
            this.newLine();
            n += cArray.length;
        }
    }

    public void writeObject(Object object) throws IOException {
        byte[] byArray;
        String string;
        if (object instanceof X509Certificate) {
            string = "CERTIFICATE";
            try {
                byArray = ((X509Certificate)object).getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Cannot encode object: " + certificateEncodingException.toString());
            }
        } else if (object instanceof PrivateKey) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Key)object).getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)aSN1InputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            if (object instanceof RSAPrivateKey) {
                string = "RSA PRIVATE KEY";
                aSN1OutputStream.writeObject(privateKeyInfo.getPrivateKey());
            } else if (object instanceof DSAPrivateKey) {
                string = "DSA PRIVATE KEY";
                DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(new DERInteger(0));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getP()));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getQ()));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getG()));
                BigInteger bigInteger = ((DSAPrivateKey)object).getX();
                BigInteger bigInteger2 = dSAParameter.getG().modPow(bigInteger, dSAParameter.getP());
                aSN1EncodableVector.add(new DERInteger(bigInteger2));
                aSN1EncodableVector.add(new DERInteger(bigInteger));
                aSN1OutputStream.writeObject(new DERSequence(aSN1EncodableVector));
            } else {
                throw new IOException("Cannot identify private key");
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else if (object instanceof X509AttributeCertificate) {
            string = "ATTRIBUTE CERTIFICATE";
            byArray = ((X509V2AttributeCertificate)object).getEncoded();
        } else if (object instanceof PKCS10CertificationRequest) {
            string = "CERTIFICATE REQUEST";
            byArray = ((PKCS10CertificationRequest)object).getEncoded();
        } else {
            throw new IOException("unknown object passed - can't encode.");
        }
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
        this.writeEncoded(byArray);
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

