/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.Thumbnailator;
import net.coobird.thumbnailator.filters.Canvas;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.filters.Pipeline;
import net.coobird.thumbnailator.filters.Rotation;
import net.coobird.thumbnailator.filters.Watermark;
import net.coobird.thumbnailator.geometry.AbsoluteSize;
import net.coobird.thumbnailator.geometry.Coordinate;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.geometry.Size;
import net.coobird.thumbnailator.name.Rename;
import net.coobird.thumbnailator.resizers.BicubicResizer;
import net.coobird.thumbnailator.resizers.BilinearResizer;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.ProgressiveBilinearResizer;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;
import net.coobird.thumbnailator.resizers.configurations.AlphaInterpolation;
import net.coobird.thumbnailator.resizers.configurations.Antialiasing;
import net.coobird.thumbnailator.resizers.configurations.Dithering;
import net.coobird.thumbnailator.resizers.configurations.Rendering;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;
import net.coobird.thumbnailator.tasks.SourceSinkThumbnailTask;
import net.coobird.thumbnailator.tasks.io.BufferedImageSink;
import net.coobird.thumbnailator.tasks.io.BufferedImageSource;
import net.coobird.thumbnailator.tasks.io.FileImageSink;
import net.coobird.thumbnailator.tasks.io.FileImageSource;
import net.coobird.thumbnailator.tasks.io.ImageSource;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;
import net.coobird.thumbnailator.tasks.io.OutputStreamImageSink;
import net.coobird.thumbnailator.tasks.io.URLImageSource;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

public final class Thumbnails {
    private Thumbnails() {
    }

    private static void validateDimensions(int width, int height) {
        if (width <= 0 && height <= 0) {
            throw new IllegalArgumentException("Destination image dimensions must not be less than 0 pixels.");
        }
        if (width <= 0 || height <= 0) {
            String dimension = width == 0 ? "width" : "height";
            throw new IllegalArgumentException("Destination image " + dimension + " must not be " + "less than or equal to 0 pixels.");
        }
    }

    private static void checkForNull(Object o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
    }

    private static void checkForEmpty(Object[] o, String message) {
        if (o.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void checkForEmpty(Iterable<?> o, String message) {
        if (!o.iterator().hasNext()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Builder<File> of(String ... files) {
        Thumbnails.checkForNull(files, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(files, "Cannot specify an empty array for input files.");
        return Builder.ofStrings(Arrays.asList(files));
    }

    public static Builder<File> of(File ... files) {
        Thumbnails.checkForNull(files, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(files, "Cannot specify an empty array for input files.");
        return Builder.ofFiles(Arrays.asList(files));
    }

    public static Builder<URL> of(URL ... urls) {
        Thumbnails.checkForNull(urls, "Cannot specify null for input URLs.");
        Thumbnails.checkForEmpty(urls, "Cannot specify an empty array for input URLs.");
        return Builder.ofUrls(Arrays.asList(urls));
    }

    public static Builder<? extends InputStream> of(InputStream ... inputStreams) {
        Thumbnails.checkForNull(inputStreams, "Cannot specify null for InputStreams.");
        Thumbnails.checkForEmpty(inputStreams, "Cannot specify an empty array for InputStreams.");
        return Builder.ofInputStreams(Arrays.asList(inputStreams));
    }

    public static Builder<BufferedImage> of(BufferedImage ... images) {
        Thumbnails.checkForNull(images, "Cannot specify null for images.");
        Thumbnails.checkForEmpty(images, "Cannot specify an empty array for images.");
        return Builder.ofBufferedImages(Arrays.asList(images));
    }

    public static Builder<File> fromFilenames(Iterable<String> files) {
        Thumbnails.checkForNull(files, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(files, "Cannot specify an empty collection for input files.");
        return Builder.ofStrings(files);
    }

    public static Builder<File> fromFiles(Iterable<File> files) {
        Thumbnails.checkForNull(files, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(files, "Cannot specify an empty collection for input files.");
        return Builder.ofFiles(files);
    }

    public static Builder<URL> fromURLs(Iterable<URL> urls) {
        Thumbnails.checkForNull(urls, "Cannot specify null for input URLs.");
        Thumbnails.checkForEmpty(urls, "Cannot specify an empty collection for input URLs.");
        return Builder.ofUrls(urls);
    }

    public static Builder<InputStream> fromInputStreams(Iterable<? extends InputStream> inputStreams) {
        Thumbnails.checkForNull(inputStreams, "Cannot specify null for InputStreams.");
        Thumbnails.checkForEmpty(inputStreams, "Cannot specify an empty collection for InputStreams.");
        return Builder.ofInputStreams(inputStreams);
    }

    public static Builder<BufferedImage> fromImages(Iterable<BufferedImage> images) {
        Thumbnails.checkForNull(images, "Cannot specify null for images.");
        Thumbnails.checkForEmpty(images, "Cannot specify an empty collection for images.");
        return Builder.ofBufferedImages(images);
    }

    public static class Builder<T> {
        private final Iterable<ImageSource<T>> sources;
        private final Map<Properties, Status> statusMap = new HashMap<Properties, Status>();
        private static int IMAGE_TYPE_UNSPECIFIED = -1;
        private static final int DIMENSION_NOT_SPECIFIED = -1;
        private int width;
        private int height;
        private double scaleWidth;
        private double scaleHeight;
        private Region sourceRegion;
        private int imageType;
        private boolean keepAspectRatio;
        private String outputFormat;
        private String outputFormatType;
        private float outputQuality;
        private ScalingMode scalingMode;
        private AlphaInterpolation alphaInterpolation;
        private Dithering dithering;
        private Antialiasing antialiasing;
        private Rendering rendering;
        private ResizerFactory resizerFactory;
        private boolean allowOverwrite;
        private boolean fitWithinDimenions;
        private boolean useExifOrientation;
        private Position croppingPosition;
        private Pipeline filterPipeline;

        private Builder(Iterable<ImageSource<T>> sources) {
            this.statusMap.put(Properties.SIZE, Status.NOT_READY);
            this.statusMap.put(Properties.WIDTH, Status.OPTIONAL);
            this.statusMap.put(Properties.HEIGHT, Status.OPTIONAL);
            this.statusMap.put(Properties.SCALE, Status.NOT_READY);
            this.statusMap.put(Properties.SOURCE_REGION, Status.OPTIONAL);
            this.statusMap.put(Properties.IMAGE_TYPE, Status.OPTIONAL);
            this.statusMap.put(Properties.SCALING_MODE, Status.OPTIONAL);
            this.statusMap.put(Properties.ALPHA_INTERPOLATION, Status.OPTIONAL);
            this.statusMap.put(Properties.ANTIALIASING, Status.OPTIONAL);
            this.statusMap.put(Properties.DITHERING, Status.OPTIONAL);
            this.statusMap.put(Properties.RENDERING, Status.OPTIONAL);
            this.statusMap.put(Properties.KEEP_ASPECT_RATIO, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_FORMAT, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_FORMAT_TYPE, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_QUALITY, Status.OPTIONAL);
            this.statusMap.put(Properties.RESIZER, Status.OPTIONAL);
            this.statusMap.put(Properties.RESIZER_FACTORY, Status.OPTIONAL);
            this.statusMap.put(Properties.ALLOW_OVERWRITE, Status.OPTIONAL);
            this.statusMap.put(Properties.CROP, Status.OPTIONAL);
            this.statusMap.put(Properties.USE_EXIF_ORIENTATION, Status.OPTIONAL);
            this.width = -1;
            this.height = -1;
            this.scaleWidth = Double.NaN;
            this.scaleHeight = Double.NaN;
            this.imageType = IMAGE_TYPE_UNSPECIFIED;
            this.keepAspectRatio = true;
            this.outputFormat = "\u0000";
            this.outputFormatType = ThumbnailParameter.DEFAULT_FORMAT_TYPE;
            this.outputQuality = Float.NaN;
            this.scalingMode = ScalingMode.PROGRESSIVE_BILINEAR;
            this.alphaInterpolation = AlphaInterpolation.DEFAULT;
            this.dithering = Dithering.DEFAULT;
            this.antialiasing = Antialiasing.DEFAULT;
            this.rendering = Rendering.DEFAULT;
            this.resizerFactory = DefaultResizerFactory.getInstance();
            this.allowOverwrite = true;
            this.fitWithinDimenions = true;
            this.useExifOrientation = true;
            this.croppingPosition = null;
            this.filterPipeline = new Pipeline();
            this.sources = sources;
            this.statusMap.put(Properties.OUTPUT_FORMAT, Status.OPTIONAL);
        }

        private static Builder<File> ofStrings(Iterable<String> filenames) {
            StringImageSourceIterator iter = new StringImageSourceIterator(filenames);
            return new Builder<File>(iter);
        }

        private static Builder<File> ofFiles(Iterable<File> files) {
            FileImageSourceIterator iter = new FileImageSourceIterator(files);
            return new Builder<File>(iter);
        }

        private static Builder<URL> ofUrls(Iterable<URL> urls) {
            URLImageSourceIterator iter = new URLImageSourceIterator(urls);
            return new Builder<URL>(iter);
        }

        private static Builder<InputStream> ofInputStreams(Iterable<? extends InputStream> inputStreams) {
            InputStreamImageSourceIterator iter = new InputStreamImageSourceIterator(inputStreams);
            return new Builder<InputStream>(iter);
        }

        private static Builder<BufferedImage> ofBufferedImages(Iterable<BufferedImage> images) {
            BufferedImageImageSourceIterator iter = new BufferedImageImageSourceIterator(images);
            return new Builder<BufferedImage>(iter);
        }

        private void updateStatus(Properties property, Status newStatus) {
            if (this.statusMap.get(property) == Status.ALREADY_SET) {
                throw new IllegalStateException(String.valueOf(property.getName()) + " is already set.");
            }
            if (newStatus != Status.CANNOT_SET && this.statusMap.get(property) == Status.CANNOT_SET) {
                throw new IllegalStateException(String.valueOf(property.getName()) + " cannot be set.");
            }
            this.statusMap.put(property, newStatus);
        }

        public Builder<T> size(int width, int height) {
            this.updateStatus(Properties.SIZE, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            Thumbnails.validateDimensions(width, height);
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<T> width(int width) {
            if (this.statusMap.get(Properties.SIZE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            }
            if (this.statusMap.get(Properties.SCALE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            }
            this.updateStatus(Properties.WIDTH, Status.ALREADY_SET);
            Thumbnails.validateDimensions(width, Integer.MAX_VALUE);
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            if (this.statusMap.get(Properties.SIZE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            }
            if (this.statusMap.get(Properties.SCALE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            }
            this.updateStatus(Properties.HEIGHT, Status.ALREADY_SET);
            Thumbnails.validateDimensions(Integer.MAX_VALUE, height);
            this.height = height;
            return this;
        }

        public Builder<T> forceSize(int width, int height) {
            this.updateStatus(Properties.SIZE, Status.ALREADY_SET);
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            Thumbnails.validateDimensions(width, height);
            this.width = width;
            this.height = height;
            this.keepAspectRatio = false;
            return this;
        }

        public Builder<T> scale(double scale) {
            return this.scale(scale, scale);
        }

        public Builder<T> scale(double scaleWidth, double scaleHeight) {
            this.updateStatus(Properties.SCALE, Status.ALREADY_SET);
            this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.CANNOT_SET);
            if (scaleWidth <= 0.0 || scaleHeight <= 0.0) {
                throw new IllegalArgumentException("The scaling factor is equal to or less than 0.");
            }
            if (Double.isNaN(scaleWidth) || Double.isNaN(scaleHeight)) {
                throw new IllegalArgumentException("The scaling factor is not a number.");
            }
            if (Double.isInfinite(scaleWidth) || Double.isInfinite(scaleHeight)) {
                throw new IllegalArgumentException("The scaling factor cannot be infinity.");
            }
            this.scaleWidth = scaleWidth;
            this.scaleHeight = scaleHeight;
            return this;
        }

        public Builder<T> sourceRegion(Region sourceRegion) {
            if (sourceRegion == null) {
                throw new NullPointerException("Region cannot be null.");
            }
            this.updateStatus(Properties.SOURCE_REGION, Status.ALREADY_SET);
            this.sourceRegion = sourceRegion;
            return this;
        }

        public Builder<T> sourceRegion(Position position, Size size) {
            if (position == null) {
                throw new NullPointerException("Position cannot be null.");
            }
            if (size == null) {
                throw new NullPointerException("Size cannot be null.");
            }
            return this.sourceRegion(new Region(position, size));
        }

        public Builder<T> sourceRegion(int x, int y, int width, int height) {
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("Width and height must be greater than 0.");
            }
            return this.sourceRegion(new Coordinate(x, y), new AbsoluteSize(width, height));
        }

        public Builder<T> sourceRegion(Position position, int width, int height) {
            if (position == null) {
                throw new NullPointerException("Position cannot be null.");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("Width and height must be greater than 0.");
            }
            return this.sourceRegion(position, new AbsoluteSize(width, height));
        }

        public Builder<T> sourceRegion(Rectangle region) {
            if (region == null) {
                throw new NullPointerException("Region cannot be null.");
            }
            return this.sourceRegion(new Coordinate(region.x, region.y), new AbsoluteSize(region.getSize()));
        }

        public Builder<T> crop(Position position) {
            Thumbnails.checkForNull(position, "Position cannot be null.");
            this.updateStatus(Properties.CROP, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            this.croppingPosition = position;
            this.fitWithinDimenions = false;
            return this;
        }

        public Builder<T> allowOverwrite(boolean allowOverwrite) {
            this.updateStatus(Properties.ALLOW_OVERWRITE, Status.ALREADY_SET);
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public Builder<T> imageType(int type) {
            this.updateStatus(Properties.IMAGE_TYPE, Status.ALREADY_SET);
            this.imageType = type;
            return this;
        }

        public Builder<T> scalingMode(ScalingMode config) {
            Thumbnails.checkForNull((Object)config, "Scaling mode is null.");
            this.updateStatus(Properties.SCALING_MODE, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER, Status.CANNOT_SET);
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.scalingMode = config;
            return this;
        }

        public Builder<T> resizer(Resizer resizer) {
            Thumbnails.checkForNull(resizer, "Resizer is null.");
            this.updateStatus(Properties.RESIZER, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.SCALING_MODE, Status.CANNOT_SET);
            this.resizerFactory = new FixedResizerFactory(resizer);
            return this;
        }

        public Builder<T> resizerFactory(ResizerFactory resizerFactory) {
            Thumbnails.checkForNull(resizerFactory, "ResizerFactory is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER, Status.CANNOT_SET);
            this.updateStatus(Properties.SCALING_MODE, Status.CANNOT_SET);
            this.updateStatus(Properties.ALPHA_INTERPOLATION, Status.CANNOT_SET);
            this.updateStatus(Properties.DITHERING, Status.CANNOT_SET);
            this.updateStatus(Properties.ANTIALIASING, Status.CANNOT_SET);
            this.updateStatus(Properties.RENDERING, Status.CANNOT_SET);
            this.resizerFactory = resizerFactory;
            return this;
        }

        public Builder<T> alphaInterpolation(AlphaInterpolation config) {
            Thumbnails.checkForNull(config, "Alpha interpolation is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.ALPHA_INTERPOLATION, Status.ALREADY_SET);
            this.alphaInterpolation = config;
            return this;
        }

        public Builder<T> dithering(Dithering config) {
            Thumbnails.checkForNull(config, "Dithering is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.DITHERING, Status.ALREADY_SET);
            this.dithering = config;
            return this;
        }

        public Builder<T> antialiasing(Antialiasing config) {
            Thumbnails.checkForNull(config, "Antialiasing is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.ANTIALIASING, Status.ALREADY_SET);
            this.antialiasing = config;
            return this;
        }

        public Builder<T> rendering(Rendering config) {
            Thumbnails.checkForNull(config, "Rendering is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.RENDERING, Status.ALREADY_SET);
            this.rendering = config;
            return this;
        }

        public Builder<T> keepAspectRatio(boolean keep) {
            if (this.statusMap.get(Properties.SCALE) == Status.ALREADY_SET) {
                throw new IllegalStateException("Cannot specify whether to keep the aspect ratio if the scaling factor has already been specified.");
            }
            if (this.statusMap.get(Properties.SIZE) == Status.NOT_READY) {
                throw new IllegalStateException("Cannot specify whether to keep the aspect ratio unless the size parameter has already been specified.");
            }
            if (!(this.statusMap.get(Properties.WIDTH) != Status.ALREADY_SET && this.statusMap.get(Properties.HEIGHT) != Status.ALREADY_SET || keep)) {
                throw new IllegalStateException("The aspect ratio must be preserved when the width and/or height parameter has already been specified.");
            }
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.ALREADY_SET);
            this.keepAspectRatio = keep;
            return this;
        }

        public Builder<T> outputQuality(float quality) {
            if (quality < 0.0f || quality > 1.0f) {
                throw new IllegalArgumentException("The quality setting must be in the range 0.0f and 1.0f, inclusive.");
            }
            this.updateStatus(Properties.OUTPUT_QUALITY, Status.ALREADY_SET);
            this.outputQuality = quality;
            return this;
        }

        public Builder<T> outputQuality(double quality) {
            if (quality < 0.0 || quality > 1.0) {
                throw new IllegalArgumentException("The quality setting must be in the range 0.0d and 1.0d, inclusive.");
            }
            this.updateStatus(Properties.OUTPUT_QUALITY, Status.ALREADY_SET);
            this.outputQuality = (float)quality;
            if (this.outputQuality < 0.0f) {
                this.outputQuality = 0.0f;
            } else if (this.outputQuality > 1.0f) {
                this.outputQuality = 1.0f;
            }
            return this;
        }

        public Builder<T> outputFormat(String format) {
            if (!ThumbnailatorUtils.isSupportedOutputFormat(format)) {
                throw new IllegalArgumentException("Specified format is not supported: " + format);
            }
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = format;
            return this;
        }

        public Builder<T> useOriginalFormat() {
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = ThumbnailParameter.ORIGINAL_FORMAT;
            return this;
        }

        public Builder<T> useExifOrientation(boolean useExifOrientation) {
            this.updateStatus(Properties.USE_EXIF_ORIENTATION, Status.ALREADY_SET);
            this.useExifOrientation = useExifOrientation;
            return this;
        }

        public Builder<T> determineOutputFormat() {
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = "\u0000";
            return this;
        }

        private boolean isOutputFormatNotSet() {
            return this.outputFormat == null || "\u0000".equals(this.outputFormat);
        }

        public Builder<T> outputFormatType(String formatType) {
            if (formatType != ThumbnailParameter.DEFAULT_FORMAT_TYPE && this.isOutputFormatNotSet()) {
                throw new IllegalArgumentException("Cannot set the format type if a specific output format has not been specified.");
            }
            if (!ThumbnailatorUtils.isSupportedOutputFormatType(this.outputFormat, formatType)) {
                throw new IllegalArgumentException("Specified format type (" + formatType + ") is not " + " supported for the format: " + this.outputFormat);
            }
            this.updateStatus(Properties.OUTPUT_FORMAT_TYPE, Status.ALREADY_SET);
            if (!this.statusMap.containsKey(Properties.OUTPUT_FORMAT)) {
                this.updateStatus(Properties.OUTPUT_FORMAT, Status.CANNOT_SET);
            }
            this.outputFormatType = formatType;
            return this;
        }

        public Builder<T> watermark(Watermark w) {
            if (w == null) {
                throw new NullPointerException("Watermark is null.");
            }
            this.filterPipeline.add(w);
            return this;
        }

        public Builder<T> watermark(BufferedImage image) {
            return this.watermark(Positions.CENTER, image, 0.5f);
        }

        public Builder<T> watermark(BufferedImage image, float opacity) {
            return this.watermark(Positions.CENTER, image, opacity);
        }

        public Builder<T> watermark(Position position, BufferedImage image, float opacity) {
            this.filterPipeline.add(new Watermark(position, image, opacity));
            return this;
        }

        public Builder<T> rotate(double angle) {
            this.filterPipeline.add(Rotation.newRotator(angle));
            return this;
        }

        public Builder<T> addFilter(ImageFilter filter) {
            if (filter == null) {
                throw new NullPointerException("Filter is null.");
            }
            this.filterPipeline.add(filter);
            return this;
        }

        public Builder<T> addFilters(List<ImageFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Filters is null.");
            }
            this.filterPipeline.addAll(filters);
            return this;
        }

        private void checkReadiness() {
            for (Map.Entry<Properties, Status> s : this.statusMap.entrySet()) {
                if (s.getValue() != Status.NOT_READY) continue;
                throw new IllegalStateException(String.valueOf(s.getKey().getName()) + " is not set.");
            }
        }

        private Resizer makeResizer(ScalingMode mode) {
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, this.alphaInterpolation.getValue());
            hints.put(RenderingHints.KEY_DITHERING, this.dithering.getValue());
            hints.put(RenderingHints.KEY_ANTIALIASING, this.antialiasing.getValue());
            hints.put(RenderingHints.KEY_RENDERING, this.rendering.getValue());
            if (mode == ScalingMode.BILINEAR) {
                return new BilinearResizer(hints);
            }
            if (mode == ScalingMode.BICUBIC) {
                return new BicubicResizer(hints);
            }
            if (mode == ScalingMode.PROGRESSIVE_BILINEAR) {
                return new ProgressiveBilinearResizer(hints);
            }
            return new ProgressiveBilinearResizer(hints);
        }

        private void prepareResizerFactory() {
            if (this.statusMap.get(Properties.SCALING_MODE) == Status.ALREADY_SET) {
                this.resizerFactory = new FixedResizerFactory(this.makeResizer(this.scalingMode));
            }
        }

        private ThumbnailParameter makeParam() {
            this.prepareResizerFactory();
            int imageTypeToUse = this.imageType;
            if (this.imageType == IMAGE_TYPE_UNSPECIFIED) {
                imageTypeToUse = -1;
            }
            if (this.croppingPosition != null) {
                this.filterPipeline.addFirst(new Canvas(this.width, this.height, this.croppingPosition));
            }
            if (Double.isNaN(this.scaleWidth)) {
                if (this.width == -1 && this.height == -1) {
                    throw new IllegalStateException("The width or height must be specified. If this exception is thrown, it is due to a bug in the Thumbnailator library.");
                }
                if (this.width == -1) {
                    this.width = Integer.MAX_VALUE;
                }
                if (this.height == -1) {
                    this.height = Integer.MAX_VALUE;
                }
                return new ThumbnailParameter(new Dimension(this.width, this.height), this.sourceRegion, this.keepAspectRatio, this.outputFormat, this.outputFormatType, this.outputQuality, imageTypeToUse, this.filterPipeline.getFilters(), this.resizerFactory, this.fitWithinDimenions, this.useExifOrientation);
            }
            return new ThumbnailParameter(this.scaleWidth, this.scaleHeight, this.sourceRegion, this.keepAspectRatio, this.outputFormat, this.outputFormatType, this.outputQuality, imageTypeToUse, this.filterPipeline.getFilters(), this.resizerFactory, this.fitWithinDimenions, this.useExifOrientation);
        }

        public Iterable<BufferedImage> iterableBufferedImages() {
            this.checkReadiness();
            return new BufferedImageIterable();
        }

        public List<BufferedImage> asBufferedImages() throws IOException {
            this.checkReadiness();
            ArrayList<BufferedImage> thumbnails = new ArrayList<BufferedImage>();
            for (ImageSource<T> source : this.sources) {
                BufferedImageSink destination = new BufferedImageSink();
                Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, BufferedImage>(this.makeParam(), source, destination));
                thumbnails.add(destination.getSink());
            }
            return thumbnails;
        }

        public BufferedImage asBufferedImage() throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iter = this.sources.iterator();
            ImageSource<T> source = iter.next();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Cannot create one thumbnail from multiple original images.");
            }
            BufferedImageSink destination = new BufferedImageSink();
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, BufferedImage>(this.makeParam(), source, destination));
            return destination.getSink();
        }

        public List<File> asFiles(Iterable<File> iterable) throws IOException {
            this.checkReadiness();
            if (iterable == null) {
                throw new NullPointerException("File name iterable is null.");
            }
            ArrayList<File> destinationFiles = new ArrayList<File>();
            Iterator<File> filenameIter = iterable.iterator();
            for (ImageSource<T> source : this.sources) {
                if (!filenameIter.hasNext()) {
                    throw new IndexOutOfBoundsException("Not enough file names provided by iterator.");
                }
                ThumbnailParameter param = this.makeParam();
                FileImageSink destination = new FileImageSink(filenameIter.next(), this.allowOverwrite);
                try {
                    Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(param, source, destination));
                    destinationFiles.add(destination.getSink());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return destinationFiles;
        }

        public void toFiles(Iterable<File> iterable) throws IOException {
            this.asFiles(iterable);
        }

        public List<File> asFiles(Rename rename) throws IOException {
            return this.asFiles(null, rename);
        }

        public List<File> asFiles(File destinationDir, Rename rename) throws IOException {
            this.checkReadiness();
            if (rename == null) {
                throw new NullPointerException("Rename is null.");
            }
            if (destinationDir != null && !destinationDir.isDirectory()) {
                throw new IllegalArgumentException("Given destination is not a directory.");
            }
            ArrayList<File> destinationFiles = new ArrayList<File>();
            for (ImageSource<T> source : this.sources) {
                if (!(source instanceof FileImageSource)) {
                    throw new IllegalStateException("Cannot create thumbnails to files if original images are not from files.");
                }
                ThumbnailParameter param = this.makeParam();
                File f = ((FileImageSource)source).getSource();
                File actualDestDir = destinationDir == null ? f.getParentFile() : destinationDir;
                File destinationFile = new File(actualDestDir, rename.apply(f.getName(), param));
                FileImageSink destination = new FileImageSink(destinationFile, this.allowOverwrite);
                try {
                    Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(param, source, destination));
                    destinationFiles.add(destination.getSink());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return destinationFiles;
        }

        public void toFiles(Rename rename) throws IOException {
            this.toFiles(null, rename);
        }

        public void toFiles(File destinationDir, Rename rename) throws IOException {
            this.asFiles(destinationDir, rename);
        }

        public void toFile(File outFile) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iter = this.sources.iterator();
            ImageSource<T> source = iter.next();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to one file.");
            }
            FileImageSink destination = new FileImageSink(outFile, this.allowOverwrite);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(this.makeParam(), source, destination));
        }

        public void toFile(String outFilepath) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iter = this.sources.iterator();
            ImageSource<T> source = iter.next();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to one file.");
            }
            FileImageSink destination = new FileImageSink(outFilepath, this.allowOverwrite);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(this.makeParam(), source, destination));
        }

        public void toOutputStream(OutputStream os) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iter = this.sources.iterator();
            ImageSource<T> source = iter.next();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to a single OutputStream.");
            }
            if (source instanceof BufferedImageSource && this.isOutputFormatNotSet()) {
                throw new IllegalStateException("Output format not specified.");
            }
            OutputStreamImageSink destination = new OutputStreamImageSink(os);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, OutputStream>(this.makeParam(), source, destination));
        }

        public void toOutputStreams(Iterable<? extends OutputStream> iterable) throws IOException {
            this.checkReadiness();
            if (iterable == null) {
                throw new NullPointerException("OutputStream iterable is null.");
            }
            Iterator<? extends OutputStream> osIter = iterable.iterator();
            for (ImageSource<T> source : this.sources) {
                if (source instanceof BufferedImageSource && this.isOutputFormatNotSet()) {
                    throw new IllegalStateException("Output format not specified.");
                }
                if (!osIter.hasNext()) {
                    throw new IndexOutOfBoundsException("Not enough file names provided by iterator.");
                }
                OutputStreamImageSink destination = new OutputStreamImageSink(osIter.next());
                Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, OutputStream>(this.makeParam(), source, destination));
            }
        }

        private static final class BufferedImageImageSourceIterator
        implements Iterable<ImageSource<BufferedImage>> {
            private final Iterable<BufferedImage> image;

            private BufferedImageImageSourceIterator(Iterable<BufferedImage> images) {
                this.image = images;
            }

            @Override
            public Iterator<ImageSource<BufferedImage>> iterator() {
                return new Iterator<ImageSource<BufferedImage>>(){
                    Iterator<BufferedImage> iter;
                    {
                        this.iter = bufferedImageImageSourceIterator.image.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<BufferedImage> next() {
                        return new BufferedImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        private final class BufferedImageIterable
        implements Iterable<BufferedImage> {
            private BufferedImageIterable() {
            }

            @Override
            public Iterator<BufferedImage> iterator() {
                return new Iterator<BufferedImage>(){
                    Iterator<ImageSource<T>> sourceIter;
                    {
                        this.sourceIter = Builder.this.sources.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.sourceIter.hasNext();
                    }

                    @Override
                    public BufferedImage next() {
                        ImageSource source = this.sourceIter.next();
                        BufferedImageSink destination = new BufferedImageSink();
                        try {
                            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask(Builder.this.makeParam(), source, destination));
                        }
                        catch (IOException e) {
                            return null;
                        }
                        return destination.getSink();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove elements from this iterator.");
                    }
                };
            }
        }

        private static final class FileImageSourceIterator
        implements Iterable<ImageSource<File>> {
            private final Iterable<File> files;

            private FileImageSourceIterator(Iterable<File> files) {
                this.files = files;
            }

            @Override
            public Iterator<ImageSource<File>> iterator() {
                return new Iterator<ImageSource<File>>(){
                    Iterator<File> iter;
                    {
                        this.iter = fileImageSourceIterator.files.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<File> next() {
                        return new FileImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        private static final class InputStreamImageSourceIterator
        implements Iterable<ImageSource<InputStream>> {
            private final Iterable<? extends InputStream> inputStreams;

            private InputStreamImageSourceIterator(Iterable<? extends InputStream> inputStreams) {
                this.inputStreams = inputStreams;
            }

            @Override
            public Iterator<ImageSource<InputStream>> iterator() {
                return new Iterator<ImageSource<InputStream>>(){
                    Iterator<? extends InputStream> iter;
                    {
                        this.iter = inputStreamImageSourceIterator.inputStreams.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<InputStream> next() {
                        return new InputStreamImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        private static enum Properties implements Property
        {
            SIZE("size"),
            WIDTH("width"),
            HEIGHT("height"),
            SCALE("scale"),
            IMAGE_TYPE("imageType"),
            SCALING_MODE("scalingMode"),
            ALPHA_INTERPOLATION("alphaInterpolation"),
            ANTIALIASING("antialiasing"),
            DITHERING("dithering"),
            RENDERING("rendering"),
            KEEP_ASPECT_RATIO("keepAspectRatio"),
            OUTPUT_FORMAT("outputFormat"),
            OUTPUT_FORMAT_TYPE("outputFormatType"),
            OUTPUT_QUALITY("outputQuality"),
            RESIZER("resizer"),
            SOURCE_REGION("sourceRegion"),
            RESIZER_FACTORY("resizerFactory"),
            ALLOW_OVERWRITE("allowOverwrite"),
            CROP("crop"),
            USE_EXIF_ORIENTATION("useExifOrientation");

            private final String name;

            private Properties(String name) {
                this.name = name;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        private static interface Property {
            public String getName();
        }

        private static enum Status {
            OPTIONAL,
            READY,
            NOT_READY,
            ALREADY_SET,
            CANNOT_SET;

        }

        private static final class StringImageSourceIterator
        implements Iterable<ImageSource<File>> {
            private final Iterable<String> filenames;

            private StringImageSourceIterator(Iterable<String> filenames) {
                this.filenames = filenames;
            }

            @Override
            public Iterator<ImageSource<File>> iterator() {
                return new Iterator<ImageSource<File>>(){
                    Iterator<String> iter;
                    {
                        this.iter = stringImageSourceIterator.filenames.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<File> next() {
                        return new FileImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        private static final class URLImageSourceIterator
        implements Iterable<ImageSource<URL>> {
            private final Iterable<URL> urls;

            private URLImageSourceIterator(Iterable<URL> urls) {
                this.urls = urls;
            }

            @Override
            public Iterator<ImageSource<URL>> iterator() {
                return new Iterator<ImageSource<URL>>(){
                    Iterator<URL> iter;
                    {
                        this.iter = uRLImageSourceIterator.urls.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<URL> next() {
                        return new URLImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }
}

