/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.builders;

import java.awt.Dimension;
import java.awt.image.BufferedImage;

public final class BufferedImageBuilder {
    private static final int DEFAULT_TYPE = 2;
    private int imageType;
    private int width;
    private int height;

    public BufferedImageBuilder(Dimension size) {
        this(size.width, size.height);
    }

    public BufferedImageBuilder(Dimension size, int imageType) {
        this(size.width, size.height, imageType);
    }

    public BufferedImageBuilder(int width, int height) {
        this(width, height, 2);
    }

    public BufferedImageBuilder(int width, int height, int imageType) {
        this.size(width, height);
        this.imageType(imageType);
    }

    public BufferedImage build() {
        return new BufferedImage(this.width, this.height, this.imageType);
    }

    public BufferedImageBuilder imageType(int imageType) {
        this.imageType = imageType;
        return this;
    }

    public BufferedImageBuilder size(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public BufferedImageBuilder width(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Width must be greater than 0.");
        }
        this.width = width;
        return this;
    }

    public BufferedImageBuilder height(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be greater than 0.");
        }
        this.height = height;
        return this;
    }
}

