/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;

public final class Colorize
implements ImageFilter {
    private final Color c;

    public Colorize(Color c) {
        this.c = c;
    }

    public Colorize(Color c, float alpha) {
        this(c, (int)(255.0f * alpha));
    }

    public Colorize(Color c, int alpha) {
        if (alpha > 255 || alpha < 0) {
            throw new IllegalArgumentException("Specified alpha value is outside the range of allowed values.");
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = alpha;
        this.c = new Color(r, g, b, a);
    }

    @Override
    public BufferedImage apply(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage newImage = new BufferedImageBuilder(width, height).build();
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.setColor(this.c);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return newImage;
    }
}

