/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;

public class Rotation {
    public static final Rotator LEFT_90_DEGREES = Rotation.newRotator(-90.0);
    public static final Rotator RIGHT_90_DEGREES = Rotation.newRotator(90.0);
    public static final Rotator ROTATE_180_DEGREES = Rotation.newRotator(180.0);

    private Rotation() {
    }

    public static Rotator newRotator(final double angle) {
        Rotator r = new Rotator(){

            private double[] calculatePosition(double x, double y, double angle2) {
                angle2 = Math.toRadians(angle2);
                double nx = Math.cos(angle2) * x - Math.sin(angle2) * y;
                double ny = Math.sin(angle2) * x + Math.cos(angle2) * y;
                return new double[]{nx, ny};
            }

            @Override
            public BufferedImage apply(BufferedImage img) {
                int width = img.getWidth();
                int height = img.getHeight();
                double[][] newPositions = new double[][]{this.calculatePosition(0.0, 0.0, angle), this.calculatePosition(width, 0.0, angle), this.calculatePosition(0.0, height, angle), this.calculatePosition(width, height, angle)};
                double minX = Math.min(Math.min(newPositions[0][0], newPositions[1][0]), Math.min(newPositions[2][0], newPositions[3][0]));
                double maxX = Math.max(Math.max(newPositions[0][0], newPositions[1][0]), Math.max(newPositions[2][0], newPositions[3][0]));
                double minY = Math.min(Math.min(newPositions[0][1], newPositions[1][1]), Math.min(newPositions[2][1], newPositions[3][1]));
                double maxY = Math.max(Math.max(newPositions[0][1], newPositions[1][1]), Math.max(newPositions[2][1], newPositions[3][1]));
                int newWidth = (int)Math.round(maxX - minX);
                int newHeight = (int)Math.round(maxY - minY);
                BufferedImage newImage = new BufferedImageBuilder(newWidth, newHeight).build();
                Graphics2D g = newImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double w = (double)newWidth / 2.0;
                double h = (double)newHeight / 2.0;
                g.rotate(Math.toRadians(angle), w, h);
                int centerX = (int)Math.round((double)(newWidth - width) / 2.0);
                int centerY = (int)Math.round((double)(newHeight - height) / 2.0);
                g.drawImage((Image)img, centerX, centerY, null);
                g.dispose();
                return newImage;
            }
        };
        return r;
    }

    public static abstract class Rotator
    implements ImageFilter {
        private Rotator() {
        }
    }
}

